/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.collect.files;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import io.crate.analyze.CopyFromParserProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class CSVLineParser {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ArrayList<String> headerKeyList = new ArrayList();
    private String[] columnNamesArray;
    private final List<String> targetColumns;
    private final ObjectReader csvReader;

    public CSVLineParser(CopyFromParserProperties properties, List<String> columns) {
        this.targetColumns = columns;
        if (!properties.fileHeader()) {
            this.columnNamesArray = new String[this.targetColumns.size()];
            for (int i = 0; i < this.targetColumns.size(); ++i) {
                this.columnNamesArray[i] = this.targetColumns.get(i);
            }
        }
        CsvMapper mapper = new CsvMapper().enable(CsvParser.Feature.TRIM_SPACES);
        if (properties.emptyStringAsNull()) {
            mapper.enable(CsvParser.Feature.EMPTY_STRING_AS_NULL);
        }
        CsvSchema csvSchema = mapper.typedSchemaFor(String.class).withColumnSeparator(properties.columnSeparator());
        this.csvReader = mapper.readerWithTypedSchemaFor(Object.class).with((FormatSchema)csvSchema);
    }

    public void parseHeader(String header) throws IOException {
        MappingIterator iterator = this.csvReader.readValues(header.getBytes(StandardCharsets.UTF_8));
        iterator.readAll(this.headerKeyList);
        this.columnNamesArray = new String[this.headerKeyList.size()];
        for (int i = 0; i < this.headerKeyList.size(); ++i) {
            String headerKey = this.headerKeyList.get(i);
            if (!this.targetColumns.isEmpty() && !this.targetColumns.contains(headerKey)) continue;
            this.columnNamesArray[i] = headerKey;
        }
        HashSet<String> keySet = new HashSet<String>(this.headerKeyList);
        keySet.remove("");
        if (keySet.size() != this.headerKeyList.size() || keySet.size() == 0) {
            throw new IllegalArgumentException("Invalid header: duplicate entries or no entries present");
        }
    }

    public byte[] parse(String row, long rowNumber) throws IOException {
        MappingIterator iterator = this.csvReader.readValues(row.getBytes(StandardCharsets.UTF_8));
        this.out.reset();
        XContentBuilder jsonBuilder = new XContentBuilder((XContent)JsonXContent.JSON_XCONTENT, (OutputStream)this.out).startObject();
        int i = 0;
        int j = 0;
        while (iterator.hasNext()) {
            if (i >= this.headerKeyList.size()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Number of values exceeds number of keys in csv file at line %d", rowNumber));
            }
            if (this.columnNamesArray.length == j || i >= this.columnNamesArray.length) break;
            String key = this.columnNamesArray[i];
            Object value = iterator.next();
            ++i;
            if (key == null) continue;
            jsonBuilder.field(key, value);
            ++j;
        }
        jsonBuilder.endObject().close();
        return this.out.toByteArray();
    }

    public byte[] parseWithoutHeader(String row, long rowNumber) throws IOException {
        int i;
        MappingIterator iterator = this.csvReader.readValues(row.getBytes(StandardCharsets.UTF_8));
        this.out.reset();
        XContentBuilder jsonBuilder = new XContentBuilder((XContent)JsonXContent.JSON_XCONTENT, (OutputStream)this.out).startObject();
        for (i = 0; iterator.hasNext() && i < this.columnNamesArray.length; ++i) {
            String key = this.columnNamesArray[i];
            String value = (String)iterator.next();
            if (key == null) continue;
            jsonBuilder.field(key, value);
        }
        if (this.columnNamesArray.length > i) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Expected %d values, encountered %d at line %d. This is not allowed when there is no header provided)", this.columnNamesArray.length, i, rowNumber));
        }
        jsonBuilder.endObject().close();
        return this.out.toByteArray();
    }
}

