/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedAlterServer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.AlterServerRequest;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.ServersMetadata;
import io.crate.fdw.TransportAlterServer;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.AlterServer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class AlterServerPlan
implements Plan {
    private final ForeignDataWrappers foreignDataWrappers;
    private final AnalyzedAlterServer alterServer;

    public AlterServerPlan(ForeignDataWrappers foreignDataWrappers, AnalyzedAlterServer alterServer) {
        this.foreignDataWrappers = foreignDataWrappers;
        this.alterServer = alterServer;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        CoordinatorTxnCtx transactionContext = plannerContext.transactionContext();
        Function<Symbol, Object> convert = new SymbolEvaluator(transactionContext, plannerContext.nodeContext(), subQueryResults).bind(params);
        Metadata metadata = plannerContext.clusterState().metadata();
        ServersMetadata servers = (ServersMetadata)metadata.custom("servers");
        if (servers == null) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Server `%s` not found", this.alterServer.name()), new Object[0]);
        }
        ServersMetadata.Server server = servers.get(this.alterServer.name());
        ForeignDataWrapper fdw = this.foreignDataWrappers.get(server.fdw());
        HashSet<String> optionNames = new HashSet<String>();
        Settings.Builder optionsAdded = Settings.builder();
        Settings.Builder optionsUpdated = Settings.builder();
        ArrayList<String> optionsRemoved = new ArrayList<String>();
        Map mandatoryOptions = fdw.mandatoryServerOptions().stream().collect(Collectors.toMap(Setting::getKey, Function.identity()));
        block5: for (AlterServer.Option<Symbol> option : this.alterServer.options()) {
            if (mandatoryOptions.get(option.key()) == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unsupported server options for foreign data wrapper `%s`: %s. Valid options are: %s", server.fdw(), option.key(), fdw.mandatoryServerOptions().stream().map(Setting::getKey).collect(Collectors.joining(", "))));
            }
            if (!optionNames.add(option.key())) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Option `%s` is specified multiple times for server `%s`", option.key(), this.alterServer.name()));
            }
            switch (option.operation()) {
                case ADD: {
                    assert (option.value() != null) : "value must not be null for ADD operation";
                    optionsAdded.put(option.key(), convert.apply((Symbol)option.value()));
                    continue block5;
                }
                case DROP: {
                    if (mandatoryOptions.get(option.key()) != null) {
                        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot remove mandatory server option `%s` for server `%s`", option.key(), this.alterServer.name()));
                    }
                    optionsRemoved.add(option.key());
                    continue block5;
                }
                case SET: {
                    assert (option.value() != null) : "value must not be null for SET operation";
                    optionsUpdated.put(option.key(), convert.apply((Symbol)option.value()));
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unsupported operation: " + String.valueOf(option.operation())));
        }
        AlterServerRequest request = new AlterServerRequest(this.alterServer.name(), optionsAdded.build(), optionsUpdated.build(), optionsRemoved);
        dependencies.client().execute(TransportAlterServer.ACTION, request).whenComplete(OneRowActionListener.oneIfAcknowledged(consumer));
    }
}

