/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public record CorrelatedSubQueries(List<Symbol> correlatedSubQueries, List<Symbol> remainder) {
    public static CorrelatedSubQueries of(@Nullable Symbol from) {
        if (from == null) {
            return new CorrelatedSubQueries(List.of(), List.of());
        }
        Collection<Symbol> values = QuerySplitter.split(from).values();
        ArrayList<Symbol> remainder = new ArrayList<Symbol>(values.size());
        ArrayList<Symbol> correlatedSubQueries = new ArrayList<Symbol>(values.size());
        for (Symbol symbol : values) {
            if (symbol.any(s -> {
                SelectSymbol x;
                return s instanceof SelectSymbol && (x = (SelectSymbol)s).isCorrelated();
            })) {
                correlatedSubQueries.add(symbol);
                continue;
            }
            remainder.add(symbol);
        }
        return new CorrelatedSubQueries(correlatedSubQueries, remainder);
    }
}

