/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedCreateForeignTable;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.CreateForeignTableRequest;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.ServersMetadata;
import io.crate.fdw.TransportCreateForeignTable;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public class CreateForeignTablePlan
implements Plan {
    private final ForeignDataWrappers foreignDataWrappers;
    private final AnalyzedCreateForeignTable createTable;

    public CreateForeignTablePlan(ForeignDataWrappers foreignDataWrappers, AnalyzedCreateForeignTable createTable) {
        this.foreignDataWrappers = foreignDataWrappers;
        this.createTable = createTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @VisibleForTesting
    public static CreateForeignTableRequest toRequest(ForeignDataWrappers foreignDataWrappers, AnalyzedCreateForeignTable createTable, PlannerContext plannerContext, Row params, SubQueryResults subQueryResults) {
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        Function<Symbol, Object> toValue = new SymbolEvaluator(plannerContext.transactionContext(), plannerContext.nodeContext(), subQueryResults).bind(params);
        Metadata metadata = plannerContext.clusterState().metadata();
        ServersMetadata servers = metadata.custom("servers", ServersMetadata.EMPTY);
        ServersMetadata.Server server = servers.get(createTable.server());
        ForeignDataWrapper foreignDataWrapper = foreignDataWrappers.get(server.fdw());
        Settings.Builder optionsBuilder = Settings.builder();
        HashMap<String, Symbol> options = new HashMap<String, Symbol>(createTable.options());
        for (Setting<?> option : foreignDataWrapper.optionalTableOptions()) {
            String optionName = option.getKey();
            Symbol symbol = (Symbol)options.remove(optionName);
            if (symbol == null) continue;
            optionsBuilder.put(optionName, toValue.apply(symbol));
        }
        if (!options.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unsupported options for foreign table %s using fdw `%s`: %s. Valid options are: %s", createTable.tableName().sqlFqn(), server.fdw(), String.join((CharSequence)", ", options.keySet()), foreignDataWrapper.optionalTableOptions().stream().map(x -> x.getKey()).collect(Collectors.joining(", "))));
        }
        Map<ColumnIdent, TableElementsAnalyzer.RefBuilder> columns = createTable.columns();
        ArrayList<Reference> references = new ArrayList<Reference>();
        RelationName tableName = createTable.tableName();
        for (Map.Entry<ColumnIdent, TableElementsAnalyzer.RefBuilder> entry : columns.entrySet()) {
            TableElementsAnalyzer.RefBuilder refBuilder = entry.getValue();
            Reference reference = refBuilder.build(columns, tableName, paramBinder, toValue);
            references.add(reference);
        }
        return new CreateForeignTableRequest(tableName, createTable.ifNotExists(), references, createTable.server(), optionsBuilder.build());
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        CreateForeignTableRequest request = CreateForeignTablePlan.toRequest(this.foreignDataWrappers, this.createTable, plannerContext, params, subQueryResults);
        dependencies.client().execute(TransportCreateForeignTable.ACTION, request).whenComplete(OneRowActionListener.oneIfAcknowledged(consumer));
    }
}

