/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedDropServer;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.fdw.DropServerRequest;
import io.crate.fdw.TransportDropServer;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;

public class DropServerPlan
implements Plan {
    private final AnalyzedDropServer dropServer;

    public DropServerPlan(AnalyzedDropServer dropServer) {
        this.dropServer = dropServer;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        DropServerRequest request = new DropServerRequest(this.dropServer.names(), this.dropServer.ifExists(), this.dropServer.mode());
        dependencies.client().execute(TransportDropServer.ACTION, request).whenComplete(OneRowActionListener.oneIfAcknowledged(consumer));
    }
}

