/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.consumer;

import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.operators.Insert;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.types.DataTypes;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;

public final class InsertFromSubQueryPlanner {
    public static final String RETURNING_VERSION_ERROR_MSG = "Returning clause for Insert is only supported when all nodes in the cluster running at least version 4.2.0";

    private InsertFromSubQueryPlanner() {
    }

    public static LogicalPlan plan(AnalyzedInsertStatement statement, PlannerContext plannerContext, LogicalPlanner logicalPlanner, SubqueryPlanner subqueryPlanner) {
        if (statement.outputs() != null && !plannerContext.clusterState().nodes().getMinNodeVersion().onOrAfter(Version.V_4_2_0)) {
            throw new UnsupportedFeatureException(RETURNING_VERSION_ERROR_MSG);
        }
        List<Symbol> outputs = statement.outputs() == null ? List.of(new InputColumn(0, DataTypes.LONG)) : statement.outputs();
        ColumnIndexWriterProjection indexWriterProjection = new ColumnIndexWriterProjection(statement.tableInfo().ident(), null, statement.tableInfo().primaryKey(), statement.columns(), statement.isIgnoreDuplicateKeys(), statement.onDuplicateKeyAssignments(), statement.primaryKeySymbols(), statement.partitionedBySymbols(), statement.tableInfo().clusteredBy(), statement.clusteredBySymbol(), Settings.EMPTY, statement.tableInfo().isPartitioned(), outputs, statement.outputs() == null ? List.of() : statement.outputs(), plannerContext.nodeContext().tableStats().estimatedSizePerRow(statement.tableInfo()));
        LogicalPlan plannedSubQuery = logicalPlanner.plan(statement.subQueryRelation(), plannerContext, subqueryPlanner, true);
        EvalProjection castOutputs = EvalProjection.castValues(Symbols.typeView(statement.columns()), plannedSubQuery.outputs());
        return new Insert(plannedSubQuery, indexWriterProjection, castOutputs);
    }
}

