/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedDropSnapshot;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.TransportDeleteSnapshot;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public class DropSnapshotPlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(DropSnapshotPlan.class);
    private final AnalyzedDropSnapshot dropSnapshot;

    public DropSnapshotPlan(AnalyzedDropSnapshot dropSnapshot) {
        this.dropSnapshot = dropSnapshot;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResult) {
        DeleteSnapshotRequest request = new DeleteSnapshotRequest(this.dropSnapshot.repository(), this.dropSnapshot.snapshot());
        dependencies.client().execute(TransportDeleteSnapshot.ACTION, request).whenComplete(new OneRowActionListener<AcknowledgedResponse>(consumer, response -> {
            if (!response.isAcknowledged()) {
                LOGGER.info("delete snapshots '{}.[{}]' not acknowledged", (Object)request.repository(), (Object)request.snapshots());
            }
            return new Row1((Object)1L);
        }));
    }
}

