/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedOptimizeTable;
import io.crate.analyze.OptimizeTableSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.retention.SyncRetentionLeasesAction;
import org.elasticsearch.action.admin.indices.retention.SyncRetentionLeasesRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public class OptimizeTablePlan
implements Plan {
    private final AnalyzedOptimizeTable optimizeTable;

    public OptimizeTablePlan(AnalyzedOptimizeTable optimizeTable) {
        this.optimizeTable = optimizeTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        if (this.optimizeTable.tables().isEmpty()) {
            consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
            return;
        }
        BoundOptimizeTable stmt = OptimizeTablePlan.bind(this.optimizeTable, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults, plannerContext.clusterState().metadata());
        Settings settings = stmt.settings();
        List<PartitionName> toOptimize = stmt.partitions();
        if (OptimizeTableSettings.UPGRADE_SEGMENTS.get(settings).booleanValue()) {
            consumer.accept(InMemoryBatchIterator.of((Object)new Row1((Object)-1L), (Object)SentinelRow.SENTINEL), null);
        } else {
            ForceMergeRequest request = new ForceMergeRequest(toOptimize);
            request.maxNumSegments(OptimizeTableSettings.MAX_NUM_SEGMENTS.get(settings));
            request.onlyExpungeDeletes(OptimizeTableSettings.ONLY_EXPUNGE_DELETES.get(settings));
            request.flush(OptimizeTableSettings.FLUSH.get(settings));
            ((CompletableFuture)this.trySyncRetentionLeases(dependencies, toOptimize).handle((broadcastResponse, throwable) -> null)).thenRun(() -> dependencies.client().execute(ForceMergeAction.INSTANCE, request).whenComplete(new OneRowActionListener<ForceMergeResponse>(consumer, forceMergeResponse -> new Row1((Object)(toOptimize.size() == 0 ? -1L : (long)toOptimize.size())))));
        }
    }

    private CompletableFuture<BroadcastResponse> trySyncRetentionLeases(DependencyCarrier dependencies, List<PartitionName> partitions) {
        Version minNodeVersion = dependencies.clusterService().state().nodes().getMinNodeVersion();
        if (minNodeVersion.before(SyncRetentionLeasesAction.SYNC_RETENTION_LEASES_MINIMUM_VERSION)) {
            return CompletableFuture.completedFuture(BroadcastResponse.EMPTY_RESPONSE);
        }
        return dependencies.client().execute(SyncRetentionLeasesAction.INSTANCE, new SyncRetentionLeasesRequest(partitions));
    }

    @VisibleForTesting
    public static BoundOptimizeTable bind(AnalyzedOptimizeTable optimizeTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, Metadata metadata) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        GenericProperties genericProperties = optimizeTable.properties().map(eval);
        genericProperties.ensureContainsOnly(OptimizeTableSettings.SUPPORTED_SETTINGS.keySet());
        Settings settings = Settings.builder().put((GenericProperties<Object>)genericProperties).build();
        OptimizeTablePlan.validateSettings(settings, genericProperties);
        ArrayList<PartitionName> toOptimize = new ArrayList<PartitionName>();
        for (Map.Entry<Table<Symbol>, TableInfo> table : optimizeTable.tables().entrySet()) {
            TableInfo tableInfo = table.getValue();
            Table<Symbol> tableSymbol = table.getKey();
            if (tableSymbol.partitionProperties().isEmpty()) {
                toOptimize.add(new PartitionName(tableInfo.ident(), List.of()));
                continue;
            }
            assert (tableInfo instanceof DocTableInfo) : "Only DocTableInfo cases can have partition properties";
            DocTableInfo docTableInfo = (DocTableInfo)tableInfo;
            PartitionName partitionName = PartitionName.ofAssignments(docTableInfo, Lists.map((Collection)tableSymbol.partitionProperties(), x -> x.map(eval)), metadata);
            toOptimize.add(partitionName);
        }
        return new BoundOptimizeTable(toOptimize, settings);
    }

    private static void validateSettings(Settings settings, GenericProperties<?> properties) {
        if (OptimizeTableSettings.UPGRADE_SEGMENTS.get(settings).booleanValue() && properties.size() > 1) {
            throw new IllegalArgumentException("cannot use other parameters if " + OptimizeTableSettings.UPGRADE_SEGMENTS.getKey() + " is set to true");
        }
    }

    public static class BoundOptimizeTable {
        private final List<PartitionName> partitions;
        private final Settings settings;

        BoundOptimizeTable(List<PartitionName> partitions, Settings settings) {
            this.partitions = partitions;
            this.settings = settings;
        }

        public List<PartitionName> partitions() {
            return this.partitions;
        }

        public Settings settings() {
            return this.settings;
        }
    }
}

