/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dql;

import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class CountPlan
implements ExecutionPlan,
ResultDescription {
    private final CountPhase countPhase;
    private final MergePhase mergePhase;
    private int unfinishedLimit = -1;
    private int unfinishedOffset = 0;
    @Nullable
    private PositionalOrderBy unfinishedOrderBy = null;

    public CountPlan(CountPhase countPhase, MergePhase mergePhase) {
        this.countPhase = countPhase;
        this.mergePhase = mergePhase;
    }

    public CountPhase countPhase() {
        return this.countPhase;
    }

    public MergePhase mergePhase() {
        return this.mergePhase;
    }

    @Override
    public <C, R> R accept(ExecutionPlanVisitor<C, R> visitor, C context) {
        return visitor.visitCountPlan(this, context);
    }

    @Override
    public void addProjection(Projection projection) {
        this.mergePhase.addProjection(projection);
    }

    @Override
    public void addProjection(Projection projection, int unfinishedLimit, int unfinishedOffset, @Nullable PositionalOrderBy unfinishedOrderBy) {
        this.mergePhase.addProjection(projection);
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.unfinishedOrderBy = unfinishedOrderBy;
    }

    @Override
    public ResultDescription resultDescription() {
        return this;
    }

    @Override
    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.mergePhase.distributionInfo(distributionInfo);
    }

    @Override
    public Collection<String> nodeIds() {
        return this.mergePhase.nodeIds();
    }

    @Override
    @Nullable
    public PositionalOrderBy orderBy() {
        return this.unfinishedOrderBy;
    }

    @Override
    public int limit() {
        return this.unfinishedLimit;
    }

    @Override
    public int maxRowsPerNode() {
        return 1;
    }

    @Override
    public int offset() {
        return this.unfinishedOffset;
    }

    @Override
    public int numOutputs() {
        return this.mergePhase.outputTypes().size();
    }

    @Override
    public List<DataType<?>> streamOutputs() {
        return this.mergePhase.outputTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountPlan countPlan = (CountPlan)o;
        return this.unfinishedLimit == countPlan.unfinishedLimit && this.unfinishedOffset == countPlan.unfinishedOffset && Objects.equals(this.countPhase, countPlan.countPhase) && Objects.equals(this.mergePhase, countPlan.mergePhase) && Objects.equals(this.unfinishedOrderBy, countPlan.unfinishedOrderBy);
    }

    public int hashCode() {
        return Objects.hash(this.countPhase, this.mergePhase, this.unfinishedLimit, this.unfinishedOffset, this.unfinishedOrderBy);
    }
}

