/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.common.collections.Lists;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.LogicalPlan;
import io.crate.sql.tree.JoinType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJoinPlan
implements LogicalPlan {
    protected final LogicalPlan lhs;
    protected final LogicalPlan rhs;
    @Nullable
    protected final Symbol joinCondition;
    protected final JoinType joinType;
    protected final LookUpJoin lookupJoin;

    protected AbstractJoinPlan(LogicalPlan lhs, LogicalPlan rhs, @Nullable Symbol joinCondition, JoinType joinType, LookUpJoin lookupJoin) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.joinCondition = joinCondition;
        this.joinType = joinType;
        this.lookupJoin = lookupJoin;
    }

    public LogicalPlan lhs() {
        return this.lhs;
    }

    public LogicalPlan rhs() {
        return this.rhs;
    }

    public LookUpJoin lookUpJoin() {
        return this.lookupJoin;
    }

    @Override
    public List<Symbol> outputs() {
        if (this.joinType == JoinType.SEMI) {
            return this.lhs.outputs();
        }
        return Lists.concat(this.lhs.outputs(), this.rhs.outputs());
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        Map<LogicalPlan, SelectSymbol> leftDeps = this.lhs.dependencies();
        Map<LogicalPlan, SelectSymbol> rightDeps = this.rhs.dependencies();
        HashMap<LogicalPlan, SelectSymbol> deps = HashMap.newHashMap(leftDeps.size() + rightDeps.size());
        deps.putAll(leftDeps);
        deps.putAll(rightDeps);
        return deps;
    }

    @Nullable
    public Symbol joinCondition() {
        return this.joinCondition;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    @Override
    public List<RelationName> relationNames() {
        return Lists.concatUnique(this.lhs.relationNames(), this.rhs.relationNames());
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.lhs, this.rhs);
    }

    @Override
    public boolean supportsDistributedReads() {
        return this.lhs.supportsDistributedReads() && this.rhs.supportsDistributedReads();
    }

    protected static MergePhase buildMergePhaseForJoin(PlannerContext plannerContext, ResultDescription resultDescription, Collection<String> executionNodes) {
        List<Projection> projections = Collections.emptyList();
        if (resultDescription.hasRemainingLimitOrOffset()) {
            projections = Collections.singletonList(ProjectionBuilder.limitAndOffsetOrEvalIfNeeded(resultDescription.limit(), resultDescription.offset(), resultDescription.numOutputs(), resultDescription.streamOutputs()));
        }
        return new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), "join-merge", resultDescription.nodeIds().size(), 1, executionNodes, resultDescription.streamOutputs(), projections, resultDescription.nodeIds(), DistributionInfo.DEFAULT_SAME_NODE, resultDescription.orderBy());
    }

    public static enum LookUpJoin {
        LEFT,
        RIGHT,
        NONE;


        public LookUpJoin invert() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> RIGHT;
                case 1 -> LEFT;
                case 2 -> NONE;
            };
        }
    }
}

