/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.GeneratedColumnExpander;
import io.crate.analyze.OrderBy;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.where.WhereClauseAnalyzer;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.exceptions.VersioningValidationException;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.FetchStub;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.DocReferences;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.ShardedTable;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.WhereClauseOptimizer;
import io.crate.planner.consumer.OrderByPositionVisitor;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.operators.EnsureNoMatchPredicate;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.symbol.Optimizer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class Collect
implements LogicalPlan {
    private static final String COLLECT_PHASE_NAME = "collect";
    final AbstractTableRelation<?> relation;
    private final List<Symbol> outputs;
    private final List<AbstractTableRelation<?>> baseTables;
    final TableInfo tableInfo;
    final WhereClause immutableWhere;
    WhereClause mutableBoundWhere;
    WhereClauseOptimizer.DetailedQuery detailedQuery;

    public Collect(Collect collect, WhereClauseOptimizer.DetailedQuery detailedQuery) {
        assert (detailedQuery.docKeys().isEmpty()) : "`Collect` operator must not be used with queries that have docKeys. Use the `Get` operator instead";
        this.outputs = collect.outputs();
        this.baseTables = collect.baseTables;
        this.relation = collect.relation;
        this.mutableBoundWhere = collect.mutableBoundWhere;
        this.immutableWhere = collect.immutableWhere;
        this.tableInfo = collect.relation.tableInfo();
        this.detailedQuery = detailedQuery;
    }

    public Collect(AbstractTableRelation<?> relation, List<Symbol> outputs, WhereClause where) {
        this.outputs = outputs;
        this.baseTables = List.of(relation);
        if (where.hasQuery() && !(relation instanceof DocTableRelation)) {
            EnsureNoMatchPredicate.ensureNoMatchPredicate(where.queryOrFallback(), "Cannot use MATCH on system tables");
        }
        this.relation = relation;
        this.immutableWhere = where;
        this.mutableBoundWhere = where;
        this.tableInfo = relation.tableInfo();
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(plannerContext.nodeContext(), RowGranularity.CLUSTER, null, this.relation);
        Function<Symbol, Symbol> binder = new SubQueryAndParamBinder(params, subQueryResults).andThen(x -> normalizer.normalize((Symbol)x, plannerContext.transactionContext()));
        RoutedCollectPhase collectPhase = this.createPhase(plannerContext, hints, binder, params, subQueryResults);
        PositionalOrderBy positionalOrderBy = Collect.getPositionalOrderBy(order, this.outputs);
        if (positionalOrderBy != null) {
            if (hints.contains((Object)PlanHint.PREFER_SOURCE_LOOKUP)) {
                order = order.map(DocReferences::toDocLookup);
            }
            collectPhase.orderBy(order.map(binder).exclude(s -> {
                AliasSymbol alias;
                return s instanceof Literal || s instanceof AliasSymbol && (alias = (AliasSymbol)s).symbol() instanceof Literal;
            }));
        }
        int limitAndOffset = Limit.limitAndOffset(limit, offset);
        Collect.maybeApplyPageSize(limitAndOffset, pageSizeHint, collectPhase);
        return new io.crate.planner.node.dql.Collect(collectPhase, -1, 0, this.outputs.size(), limitAndOffset, positionalOrderBy);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public WhereClause where() {
        return this.immutableWhere;
    }

    public WhereClauseOptimizer.DetailedQuery detailedQuery() {
        return this.detailedQuery;
    }

    public AbstractTableRelation<?> relation() {
        return this.relation;
    }

    private static boolean noLuceneSortSupport(OrderBy order) {
        for (Symbol sortKey : order.orderBySymbols()) {
            if (!sortKey.any(Collect::isPartitionColOrAnalyzed)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPartitionColOrAnalyzed(Symbol s) {
        Reference ref;
        return s instanceof Reference && ((ref = (Reference)s).granularity() == RowGranularity.PARTITION || ref.indexType() == IndexType.FULLTEXT);
    }

    @Nullable
    private static PositionalOrderBy getPositionalOrderBy(@Nullable OrderBy order, List<Symbol> outputs) {
        if (order == null) {
            return null;
        }
        int[] positions = OrderByPositionVisitor.orderByPositionsOrNull(order.orderBySymbols(), outputs);
        if (positions == null) {
            return null;
        }
        if (Collect.noLuceneSortSupport(order)) {
            return null;
        }
        return new PositionalOrderBy(positions, order.reverseFlags(), order.nullsFirst());
    }

    private static void maybeApplyPageSize(int limit, @Nullable Integer pageSizeHint, RoutedCollectPhase collectPhase) {
        if (pageSizeHint == null) {
            if (limit > -1) {
                collectPhase.nodePageSizeHint(limit);
            }
        } else {
            collectPhase.pageSizeHint(pageSizeHint);
        }
    }

    private RoutedCollectPhase createPhase(PlannerContext plannerContext, Set<PlanHint> planHints, Function<Symbol, Symbol> binder, Row params, SubQueryResults subQueryResults) {
        WhereClause boundWhere;
        TableInfo tableInfo = this.tableInfo;
        if (tableInfo instanceof DocTableInfo) {
            DocTableInfo docTable = (DocTableInfo)tableInfo;
            boundWhere = this.detailedQuery == null ? this.immutableWhere.map(binder) : this.detailedQuery.toBoundWhereClause(docTable, params, subQueryResults, plannerContext.transactionContext(), plannerContext.nodeContext(), plannerContext.clusterState().metadata());
            Symbol query = GeneratedColumnExpander.maybeExpand(boundWhere.queryOrFallback(), docTable.generatedColumns(), Lists.concat(docTable.partitionedByColumns(), (Collection)Lists.map(docTable.primaryKey(), docTable::getReference)), plannerContext.nodeContext());
            if (!query.equals(boundWhere.queryOrFallback())) {
                boundWhere = new WhereClause(query, boundWhere.partitions(), boundWhere.clusteredBy());
            }
        } else {
            boundWhere = this.immutableWhere.map(binder);
        }
        this.mutableBoundWhere = WhereClauseAnalyzer.resolvePartitions(boundWhere, this.relation, plannerContext.transactionContext(), plannerContext.nodeContext(), plannerContext.clusterState().metadata());
        if (this.mutableBoundWhere.hasVersions()) {
            throw VersioningValidationException.versionInvalidUsage();
        }
        if (this.mutableBoundWhere.hasSeqNoAndPrimaryTerm()) {
            throw VersioningValidationException.seqNoAndPrimaryTermUsage();
        }
        CoordinatorSessionSettings sessionSettings = plannerContext.transactionContext().sessionSettings();
        List boundOutputs = Lists.map(this.outputs, binder);
        return new RoutedCollectPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), COLLECT_PHASE_NAME, plannerContext.allocateRouting(this.tableInfo, this.mutableBoundWhere, RoutingProvider.ShardSelection.ANY, sessionSettings), this.tableInfo.rowGranularity(), planHints.contains((Object)PlanHint.PREFER_SOURCE_LOOKUP) && this.tableInfo instanceof DocTableInfo ? Lists.map((Collection)boundOutputs, DocReferences::toDocLookup) : boundOutputs, Collections.emptyList(), Optimizer.optimizeCasts(this.mutableBoundWhere.queryOrFallback(), plannerContext), DistributionInfo.DEFAULT_BROADCAST);
    }

    @Override
    public boolean preferShardProjections() {
        return this.tableInfo instanceof DocTableInfo;
    }

    @Override
    public boolean supportsDistributedReads() {
        return this.tableInfo instanceof ShardedTable;
    }

    @Override
    public List<RelationName> relationNames() {
        return List.of(this.relation.relationName());
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "Collect has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet newOutputs = new LinkedHashSet();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.outputs, needle -> {
                int index = this.outputs.indexOf(needle);
                assert (index != -1) : "Consumer is called only when intersection is found";
                newOutputs.add(this.outputs.get(index));
            });
        }
        if (newOutputs.size() == this.outputs.size() && newOutputs.containsAll(this.outputs)) {
            return this;
        }
        return new Collect(this.relation, List.copyOf(newOutputs), this.immutableWhere);
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(Collection<Symbol> usedColumns) {
        if (!(this.tableInfo instanceof DocTableInfo)) {
            return null;
        }
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        LinkedHashMap<Symbol, Symbol> replacedOutputs = new LinkedHashMap<Symbol, Symbol>();
        ArrayList<Reference> refsToFetch = new ArrayList<Reference>();
        FetchMarker fetchMarker = new FetchMarker(this.relation.relationName(), refsToFetch);
        for (int i = 0; i < this.outputs.size(); ++i) {
            Symbol output = this.outputs.get(i);
            if (output.hasColumn(SysColumns.SCORE)) {
                newOutputs.add(output);
                replacedOutputs.put(output, output);
                continue;
            }
            if (!output.any(Symbol.IS_COLUMN)) {
                newOutputs.add(output);
                replacedOutputs.put(output, output);
                continue;
            }
            if (Symbols.any(usedColumns, (Predicate<Symbol>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/crate/expression/symbol/Symbol;)Z)((Symbol)output))) {
                newOutputs.add(output);
                replacedOutputs.put(output, output);
                continue;
            }
            Symbol outputWithFetchStub = RefReplacer.replaceRefs(output, ref -> {
                Reference sourceLookup = DocReferences.toDocLookup(ref);
                refsToFetch.add(sourceLookup);
                return new FetchStub(fetchMarker, sourceLookup);
            });
            replacedOutputs.put(output, outputWithFetchStub);
        }
        if (newOutputs.size() == this.outputs.size()) {
            return null;
        }
        newOutputs.add(0, fetchMarker);
        return new FetchRewrite(replacedOutputs, new Collect(this.relation, newOutputs, this.immutableWhere));
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    public String toString() {
        return "Collect{" + String.valueOf(this.tableInfo.ident()) + ", [" + Lists.joinOn((String)", ", this.outputs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()) + "], " + String.valueOf(this.immutableWhere) + "}";
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitCollect(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Collect[").text(this.tableInfo.ident().toString()).text(" | [").text(Lists.joinOn((String)", ", this.outputs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).text("] | ").text(this.immutableWhere.queryOrFallback().toString()).text("]");
        this.printStats(printContext);
    }
}

