/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.dsl.projection.FetchProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ReaderAllocations;
import io.crate.planner.node.dql.QueryThenFetch;
import io.crate.planner.node.fetch.FetchSource;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class Fetch
extends ForwardingLogicalPlan {
    private final List<Symbol> outputs;
    private final List<Reference> fetchRefs;
    private final Map<RelationName, FetchSource> fetchSourceByRelation;
    private final Map<Symbol, Symbol> replacedOutputs;

    public Fetch(Map<Symbol, Symbol> replacedOutputs, List<Reference> fetchRefs, Map<RelationName, FetchSource> fetchSourceByRelation, LogicalPlan source) {
        super(source);
        this.outputs = List.copyOf(replacedOutputs.keySet());
        this.replacedOutputs = replacedOutputs;
        this.fetchRefs = fetchRefs;
        this.fetchSourceByRelation = fetchSourceByRelation;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        return this;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        plannerContext.newReaderAllocations();
        ExecutionPlan executionPlan = Merge.ensureOnHandler(this.source.build(executor, plannerContext, hints, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults), plannerContext);
        ReaderAllocations readerAllocations = plannerContext.buildReaderAllocations();
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        FetchPhase fetchPhase = new FetchPhase(plannerContext.nextExecutionPhaseId(), readerAllocations.nodeReaders().keySet(), readerAllocations.bases(), readerAllocations.tableIndices(), this.fetchRefs);
        ArrayList<Symbol> boundOutputs = new ArrayList<Symbol>(this.replacedOutputs.size());
        for (Map.Entry<Symbol, Symbol> entry : this.replacedOutputs.entrySet()) {
            Symbol key = entry.getKey();
            Symbol value = entry.getValue();
            if (this.source.outputs().contains(key)) {
                boundOutputs.add((Symbol)paramBinder.apply(key));
                continue;
            }
            boundOutputs.add((Symbol)paramBinder.apply(value));
        }
        List<DataType<?>> inputTypes = Symbols.typeView(this.source.outputs());
        List boundSourceOutputs = Lists.map(this.source.outputs(), (Function)paramBinder);
        List<Symbol> fetchOutputs = InputColumns.create(boundOutputs, new InputColumns.SourceSymbols(boundSourceOutputs));
        FetchProjection fetchProjection = new FetchProjection(fetchPhase.phaseId(), plannerContext.fetchSize(), this.fetchSourceByRelation, fetchOutputs, inputTypes, readerAllocations.nodeReaders(), readerAllocations.indices(), readerAllocations.indicesToIdents());
        executionPlan.addProjection(fetchProjection);
        return new QueryThenFetch(executionPlan, fetchPhase);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Fetch(this.replacedOutputs, this.fetchRefs, this.fetchSourceByRelation, (LogicalPlan)Lists.getOnlyElement(sources));
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitFetch(this, context);
    }
}

