/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class Insert
implements LogicalPlan {
    private final ColumnIndexWriterProjection writeToTable;
    @Nullable
    private final EvalProjection applyCasts;
    final LogicalPlan source;

    public Insert(LogicalPlan source, ColumnIndexWriterProjection writeToTable, @Nullable EvalProjection applyCasts) {
        this.source = source;
        this.writeToTable = writeToTable;
        this.applyCasts = applyCasts;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan sourcePlan = this.source.build(executor, plannerContext, EnumSet.of(PlanHint.PREFER_SOURCE_LOOKUP), projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
        if (this.applyCasts != null) {
            sourcePlan.addProjection(this.applyCasts);
        }
        ColumnIndexWriterProjection boundIndexWriterProjection = this.writeToTable.bind(x -> SubQueryAndParamBinder.convert(x, params, subQueryResults));
        ResultDescription resultDescription = sourcePlan.resultDescription();
        if (resultDescription.hasRemainingLimitOrOffset()) {
            ExecutionPlan localMerge = Merge.ensureOnHandler(sourcePlan, plannerContext);
            localMerge.addProjection(boundIndexWriterProjection);
            return localMerge;
        }
        sourcePlan.addProjection(boundIndexWriterProjection, -1, 0, null);
        ExecutionPlan localMerge = Merge.ensureOnHandler(sourcePlan, plannerContext);
        if (sourcePlan != localMerge) {
            localMerge.addProjection(MergeCountProjection.INSTANCE);
        }
        return localMerge;
    }

    ColumnIndexWriterProjection columnIndexWriterProjection() {
        return this.writeToTable;
    }

    @Override
    public List<Symbol> outputs() {
        return this.writeToTable.outputs();
    }

    @Override
    public List<RelationName> relationNames() {
        return List.of();
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.source);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Insert((LogicalPlan)Lists.getOnlyElement(sources), this.writeToTable, this.applyCasts);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LogicalPlan newSource = this.source.pruneOutputsExcept(this.source.outputs());
        if (newSource == this.source) {
            return this;
        }
        return this.replaceSources(List.of(newSource));
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.source.dependencies();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.INSERT;
    }

    public Collection<Projection> projections() {
        if (this.applyCasts == null) {
            return List.of(this.writeToTable);
        }
        return List.of(this.applyCasts, this.writeToTable);
    }
}

