/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.projection.LimitAndOffsetProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class Limit
extends ForwardingLogicalPlan {
    final Symbol limit;
    final Symbol offset;

    static LogicalPlan create(LogicalPlan source, @Nullable Symbol limit, @Nullable Symbol offset) {
        if (limit == null && offset == null) {
            return source;
        }
        return new Limit(source, Objects.requireNonNullElse(limit, Literal.of(-1L)), Objects.requireNonNullElse(offset, Literal.of(0)));
    }

    public Limit(LogicalPlan source, Symbol limit, Symbol offset) {
        super(source);
        this.limit = limit;
        this.offset = offset;
    }

    public Symbol limit() {
        return this.limit;
    }

    public Symbol offset() {
        return this.offset;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limitHint, int offsetHint, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        int limit = Objects.requireNonNullElse(DataTypes.INTEGER.sanitizeValue(SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), this.limit, params, subQueryResults)), -1);
        int offset = Objects.requireNonNullElse(DataTypes.INTEGER.sanitizeValue(SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), this.offset, params, subQueryResults)), 0);
        ExecutionPlan executionPlan = this.source.build(executor, plannerContext, planHints, projectionBuilder, limit, offset, order, pageSizeHint, params, subQueryResults);
        List<DataType<?>> sourceTypes = Symbols.typeView(this.source.outputs());
        ResultDescription resultDescription = executionPlan.resultDescription();
        if (limit == -1 && offset == 0) {
            return executionPlan;
        }
        if (resultDescription.hasRemainingLimitOrOffset() && (resultDescription.limit() != limit || resultDescription.offset() != offset)) {
            executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
            resultDescription = executionPlan.resultDescription();
        }
        if (ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), resultDescription.nodeIds())) {
            executionPlan.addProjection(new LimitAndOffsetProjection(limit, offset, sourceTypes), -1, 0, resultDescription.orderBy());
        } else if (resultDescription.limit() != limit || resultDescription.offset() != 0) {
            executionPlan.addProjection(new LimitAndOffsetProjection(limit + offset, 0, sourceTypes), limit, offset, resultDescription.orderBy());
        }
        return executionPlan;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Limit((LogicalPlan)Lists.getOnlyElement(sources), this.limit, this.offset);
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(Collection<Symbol> usedColumns) {
        FetchRewrite fetchRewrite = this.source.rewriteToFetch(usedColumns);
        if (fetchRewrite == null) {
            return null;
        }
        return new FetchRewrite(fetchRewrite.replacedOutputs(), new Limit(fetchRewrite.newPlan(), this.limit, this.offset));
    }

    public String toString() {
        return "Limit{source=" + String.valueOf(this.source) + ", limit=" + String.valueOf(this.limit) + ", offset=" + String.valueOf(this.offset) + "}";
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Limit[").text(this.limit.toString()).text(";").text(this.offset.toString()).text("]");
        this.printStats(printContext);
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.nest(consumerArray);
    }

    static int limitAndOffset(int limit, int offset) {
        if (limit == -1) {
            return limit;
        }
        return limit + offset;
    }
}

