/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.statistics.Stats;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface LogicalPlan
extends Plan {
    public ExecutionPlan build(DependencyCarrier var1, PlannerContext var2, Set<PlanHint> var3, ProjectionBuilder var4, int var5, int var6, @Nullable OrderBy var7, @Nullable Integer var8, Row var9, SubQueryResults var10);

    public List<Symbol> outputs();

    default public boolean preferShardProjections() {
        return false;
    }

    default public boolean supportsDistributedReads() {
        return false;
    }

    public List<LogicalPlan> sources();

    public LogicalPlan replaceSources(List<LogicalPlan> var1);

    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> var1);

    @Nullable
    default public FetchRewrite rewriteToFetch(Collection<Symbol> usedColumns) {
        return null;
    }

    public Map<LogicalPlan, SelectSymbol> dependencies();

    @Override
    default public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        LogicalPlanner.execute(this, executor, plannerContext, consumer, params, subQueryResults, false);
    }

    public <C, R> R accept(LogicalPlanVisitor<C, R> var1, C var2);

    @Override
    default public Plan.StatementType type() {
        return Plan.StatementType.SELECT;
    }

    public List<RelationName> relationNames();

    default public void print(PrintContext printContext) {
        printContext.text(this.getClass().getSimpleName()).text("[").text(Lists.joinOn((String)", ", this.outputs(), (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).text("]");
        this.printStats(printContext);
        printContext.nest(Lists.map(this.sources(), x -> x::print));
    }

    default public void printStats(PrintContext printContext) {
        PlanStats planStats = printContext.planStats();
        if (planStats != null) {
            Stats stats = planStats.get(this);
            if (stats.numDocs() == -1L) {
                printContext.text(" (rows=unknown)");
            } else {
                printContext.text(" (rows=" + stats.numDocs() + ")");
            }
        }
    }
}

