/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.common.collections.Maps;
import io.crate.common.collections.Tuple;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.NestedLoopPhase;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.join.Join;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.JoinType;
import io.crate.statistics.Stats;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class NestedLoopJoin
extends AbstractJoinPlan {
    private final boolean isFiltered;
    private boolean orderByWasPushedDown = false;
    private boolean rewriteNestedLoopJoinToHashJoinDone = false;

    NestedLoopJoin(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition, boolean isFiltered) {
        super(lhs, rhs, joinCondition, joinType, AbstractJoinPlan.LookUpJoin.NONE);
        this.isFiltered = isFiltered || joinCondition != null;
    }

    public NestedLoopJoin(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition, boolean isFiltered, boolean orderByWasPushedDown, boolean rewriteEquiJoinToHashJoinDone, AbstractJoinPlan.LookUpJoin lookUpJoin) {
        super(lhs, rhs, joinCondition, joinType, lookUpJoin);
        this.isFiltered = isFiltered || joinCondition != null;
        this.orderByWasPushedDown = orderByWasPushedDown;
        this.rewriteNestedLoopJoinToHashJoinDone = rewriteEquiJoinToHashJoinDone;
    }

    public boolean isRewriteNestedLoopJoinToHashJoinDone() {
        return this.rewriteNestedLoopJoinToHashJoinDone;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Maps.concat(this.lhs.dependencies(), this.rhs.dependencies());
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        boolean expectedRowsAvailable;
        Integer childPageSizeHint = !this.isFiltered && limit != -1 ? Integer.valueOf(Limit.limitAndOffset(limit, offset)) : null;
        ExecutionPlan left = this.lhs.build(executor, plannerContext, hints, projectionBuilder, -1, 0, null, childPageSizeHint, params, subQueryResults);
        ExecutionPlan right = this.rhs.build(executor, plannerContext, hints, projectionBuilder, -1, 0, null, childPageSizeHint, params, subQueryResults);
        boolean isDistributed = this.supportsDistributedReads() && this.isFiltered && !this.joinType.isOuter();
        LogicalPlan leftLogicalPlan = this.lhs;
        LogicalPlan rightLogicalPlan = this.rhs;
        isDistributed = isDistributed && !left.resultDescription().nodeIds().isEmpty() && !right.resultDescription().nodeIds().isEmpty();
        boolean blockNlPossible = !isDistributed && NestedLoopJoin.isBlockNlPossible(left, right);
        JoinType joinType = this.joinType;
        Stats lhStats = plannerContext.planStats().get(this.lhs);
        Stats rhStats = plannerContext.planStats().get(this.rhs);
        boolean bl = expectedRowsAvailable = lhStats.numDocs() != -1L && rhStats.numDocs() != -1L;
        if (expectedRowsAvailable && !this.orderByWasPushedDown && joinType.supportsInversion() && blockNlPossible && lhStats.numDocs() > rhStats.numDocs()) {
            ExecutionPlan tmpExecutionPlan = left;
            left = right;
            right = tmpExecutionPlan;
            leftLogicalPlan = this.rhs;
            rightLogicalPlan = this.lhs;
            joinType = joinType.invert();
        }
        Tuple<Collection<String>, List<MergePhase>> joinExecutionNodesAndMergePhases = this.configureExecution(left, right, plannerContext, isDistributed);
        List joinOutputs = Lists.concat(leftLogicalPlan.outputs(), rightLogicalPlan.outputs());
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        Symbol joinInput = null;
        if (this.joinCondition != null) {
            joinInput = InputColumns.create(paramBinder.apply(this.joinCondition), joinOutputs);
        }
        NestedLoopPhase nlPhase = new NestedLoopPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), isDistributed ? "distributed-nested-loop" : "nested-loop", Collections.singletonList(NestedLoopJoin.createJoinProjection(this.outputs(), joinOutputs)), (MergePhase)((List)joinExecutionNodesAndMergePhases.v2()).get(0), (MergePhase)((List)joinExecutionNodesAndMergePhases.v2()).get(1), leftLogicalPlan.outputs().size(), rightLogicalPlan.outputs().size(), (Collection)joinExecutionNodesAndMergePhases.v1(), joinType, joinInput, Symbols.typeView(leftLogicalPlan.outputs()), lhStats.averageSizePerRowInBytes(), lhStats.numDocs(), blockNlPossible);
        PositionalOrderBy orderByFromLeft = left.resultDescription().orderBy();
        return new Join(nlPhase, left, right, -1, 0, -1, this.outputs().size(), orderByFromLeft);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new NestedLoopJoin(sources.get(0), sources.get(1), this.joinType, this.joinCondition, this.isFiltered, this.orderByWasPushedDown, this.rewriteNestedLoopJoinToHashJoinDone, this.lookupJoin);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> lhsToKeep = new LinkedHashSet<Symbol>();
        LinkedHashSet<Symbol> rhsToKeep = new LinkedHashSet<Symbol>();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.lhs.outputs(), lhsToKeep::add);
            Symbols.intersection(outputToKeep, this.rhs.outputs(), rhsToKeep::add);
        }
        if (this.joinCondition != null) {
            if (lhsToKeep.isEmpty() && this.lookupJoin == AbstractJoinPlan.LookUpJoin.RIGHT) {
                Symbols.intersection(this.joinCondition, this.rhs.outputs(), rhsToKeep::add);
                return this.rhs.pruneOutputsExcept(rhsToKeep);
            }
            if (rhsToKeep.isEmpty() && this.lookupJoin == AbstractJoinPlan.LookUpJoin.LEFT) {
                Symbols.intersection(this.joinCondition, this.lhs.outputs(), lhsToKeep::add);
                return this.lhs.pruneOutputsExcept(lhsToKeep);
            }
            Symbols.intersection(this.joinCondition, this.lhs.outputs(), lhsToKeep::add);
            Symbols.intersection(this.joinCondition, this.rhs.outputs(), rhsToKeep::add);
        }
        LogicalPlan newLhs = this.lhs.pruneOutputsExcept(lhsToKeep);
        LogicalPlan newRhs = this.rhs.pruneOutputsExcept(rhsToKeep);
        if (newLhs == this.lhs && newRhs == this.rhs) {
            return this;
        }
        return new NestedLoopJoin(newLhs, newRhs, this.joinType, this.joinCondition, this.isFiltered, this.orderByWasPushedDown, this.rewriteNestedLoopJoinToHashJoinDone, this.lookupJoin);
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(Collection<Symbol> usedColumns) {
        LinkedHashSet<Symbol> usedFromLeft = new LinkedHashSet<Symbol>();
        LinkedHashSet<Symbol> usedFromRight = new LinkedHashSet<Symbol>();
        for (Symbol usedColumn : usedColumns) {
            Symbols.intersection(usedColumn, this.lhs.outputs(), usedFromLeft::add);
            Symbols.intersection(usedColumn, this.rhs.outputs(), usedFromRight::add);
        }
        if (this.joinCondition != null) {
            Symbols.intersection(this.joinCondition, this.lhs.outputs(), usedFromLeft::add);
            Symbols.intersection(this.joinCondition, this.rhs.outputs(), usedFromRight::add);
        }
        FetchRewrite lhsFetchRewrite = this.lhs.rewriteToFetch(usedFromLeft);
        FetchRewrite rhsFetchRewrite = this.rhs.rewriteToFetch(usedFromRight);
        if (lhsFetchRewrite == null && rhsFetchRewrite == null) {
            return null;
        }
        LinkedHashMap<Symbol, Symbol> allReplacedOutputs = new LinkedHashMap<Symbol, Symbol>();
        NestedLoopJoin.setReplacedOutputs(this.lhs, lhsFetchRewrite, allReplacedOutputs);
        NestedLoopJoin.setReplacedOutputs(this.rhs, rhsFetchRewrite, allReplacedOutputs);
        return new FetchRewrite(allReplacedOutputs, new NestedLoopJoin(lhsFetchRewrite == null ? this.lhs : lhsFetchRewrite.newPlan(), rhsFetchRewrite == null ? this.rhs : rhsFetchRewrite.newPlan(), this.joinType, this.joinCondition, this.isFiltered, this.orderByWasPushedDown, this.rewriteNestedLoopJoinToHashJoinDone, this.lookupJoin));
    }

    static void setReplacedOutputs(LogicalPlan operator, FetchRewrite rewrite, LinkedHashMap<Symbol, Symbol> allReplacedOutputs) {
        if (rewrite == null) {
            for (Symbol output : operator.outputs()) {
                allReplacedOutputs.put(output, output);
            }
        } else {
            allReplacedOutputs.putAll(rewrite.replacedOutputs());
        }
    }

    private Tuple<Collection<String>, List<MergePhase>> configureExecution(ExecutionPlan left, ExecutionPlan right, PlannerContext plannerContext, boolean isDistributed) {
        Collection<String> nlExecutionNodes = Set.of(plannerContext.handlerNode());
        ResultDescription leftResultDesc = left.resultDescription();
        ResultDescription rightResultDesc = right.resultDescription();
        MergePhase leftMerge = null;
        MergePhase rightMerge = null;
        if (leftResultDesc.nodeIds().size() == 1 && Lists.equals(leftResultDesc.nodeIds(), rightResultDesc.nodeIds()) && !rightResultDesc.hasRemainingLimitOrOffset()) {
            nlExecutionNodes = leftResultDesc.nodeIds();
            left.setDistributionInfo(DistributionInfo.DEFAULT_SAME_NODE);
            right.setDistributionInfo(DistributionInfo.DEFAULT_SAME_NODE);
        } else if (isDistributed && !leftResultDesc.hasRemainingLimitOrOffset()) {
            nlExecutionNodes = leftResultDesc.nodeIds();
            left.setDistributionInfo(DistributionInfo.DEFAULT_SAME_NODE);
            right.setDistributionInfo(DistributionInfo.DEFAULT_BROADCAST);
            rightMerge = NestedLoopJoin.buildMergePhaseForJoin(plannerContext, rightResultDesc, nlExecutionNodes);
        } else {
            left.setDistributionInfo(DistributionInfo.DEFAULT_BROADCAST);
            right.setDistributionInfo(DistributionInfo.DEFAULT_BROADCAST);
            if (NestedLoopJoin.isMergePhaseNeeded(nlExecutionNodes, leftResultDesc, false)) {
                leftMerge = NestedLoopJoin.buildMergePhaseForJoin(plannerContext, leftResultDesc, nlExecutionNodes);
            }
            if (NestedLoopJoin.isMergePhaseNeeded(nlExecutionNodes, rightResultDesc, false)) {
                rightMerge = NestedLoopJoin.buildMergePhaseForJoin(plannerContext, rightResultDesc, nlExecutionNodes);
            }
        }
        return new Tuple(nlExecutionNodes, Arrays.asList(leftMerge, rightMerge));
    }

    static Projection createJoinProjection(List<Symbol> outputs, List<Symbol> joinOutputs) {
        List<Symbol> projectionOutputs = InputColumns.create(outputs, new InputColumns.SourceSymbols(joinOutputs));
        return new EvalProjection(projectionOutputs);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitNestedLoopJoin(this, context);
    }

    private static boolean isBlockNlPossible(ExecutionPlan left, ExecutionPlan right) {
        return left.resultDescription().orderBy() == null && left.resultDescription().nodeIds().size() <= 1 && Lists.equals(left.resultDescription().nodeIds(), right.resultDescription().nodeIds());
    }

    public boolean orderByWasPushedDown() {
        return this.orderByWasPushedDown;
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("NestedLoopJoin[").text(this.joinType.toString());
        if (this.joinCondition != null) {
            printContext.text(" | ").text(this.joinCondition.toString());
        }
        printContext.text("]");
        this.printStats(printContext);
        printContext.nest(Lists.map(this.sources(), x -> x::print));
    }

    private static boolean isMergePhaseNeeded(Collection<String> executionNodes, ResultDescription resultDescription, boolean isDistributed) {
        return isDistributed || resultDescription.hasRemainingLimitOrOffset() || !Lists.equals(resultDescription.nodeIds(), executionNodes);
    }

    public String toString() {
        return "NestedLoopJoin{joinCondition=" + String.valueOf(this.joinCondition) + ", joinType=" + String.valueOf(this.joinType) + ", isFiltered=" + this.isFiltered + ", lhs=" + String.valueOf(this.lhs) + ", rhs=" + String.valueOf(this.rhs) + ", outputs=" + String.valueOf(this.outputs()) + "}";
    }
}

