/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import io.crate.data.Row;
import io.crate.expression.symbol.OuterColumn;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubQueryResults {
    private static final ObjectIntHashMap<OuterColumn> EMPTY_OUTER_COLUMNS = new ObjectIntHashMap();
    public static final SubQueryResults EMPTY = new SubQueryResults(Collections.emptyMap());
    private final Map<SelectSymbol, Object> valuesBySubQuery;
    private final ObjectIntMap<OuterColumn> boundOuterColumns;
    private Row inputRow = Row.EMPTY;

    public SubQueryResults(Map<SelectSymbol, Object> valuesBySubQuery) {
        this(valuesBySubQuery, (ObjectIntMap<OuterColumn>)EMPTY_OUTER_COLUMNS);
    }

    private SubQueryResults(Map<SelectSymbol, Object> valuesBySubQuery, ObjectIntMap<OuterColumn> boundOuterColumns) {
        this.valuesBySubQuery = valuesBySubQuery;
        this.boundOuterColumns = boundOuterColumns;
    }

    public Object getSafe(SelectSymbol key) {
        Object value = this.valuesBySubQuery.get(key);
        if (value == null && !this.valuesBySubQuery.containsKey(key)) {
            throw new IllegalArgumentException("Couldn't resolve value for subQuery: " + String.valueOf(key));
        }
        return value;
    }

    public Object get(OuterColumn key) {
        int index = this.boundOuterColumns.getOrDefault((Object)key, -1);
        if (index == -1) {
            throw new IllegalArgumentException("Couldn't resolve value for OuterColumn: " + String.valueOf(key));
        }
        return this.inputRow.get(index);
    }

    public SubQueryResults forCorrelation(SelectSymbol correlatedSubQuery, List<Symbol> subQueryOutputs) {
        ObjectIntHashMap outerColumnPositions = new ObjectIntHashMap();
        correlatedSubQuery.relation().visitSymbols(tree -> tree.visit(OuterColumn.class, outerColumn -> {
            int index = subQueryOutputs.indexOf(outerColumn.symbol());
            if (index < 0) {
                throw new IllegalStateException("OuterColumn `" + String.valueOf(outerColumn) + "` must appear in input of CorrelatedJoin");
            }
            outerColumnPositions.put(outerColumn, index);
        }));
        return new SubQueryResults(this.valuesBySubQuery, (ObjectIntMap<OuterColumn>)outerColumnPositions);
    }

    public void bindOuterColumnInputRow(Row inputRow) {
        this.inputRow = inputRow;
    }

    public static SubQueryResults merge(SubQueryResults subQueryResults1, SubQueryResults subQueryResults2) {
        assert (subQueryResults1.boundOuterColumns.isEmpty() || subQueryResults2.boundOuterColumns.isEmpty()) : "Can't merge two SubQueryResults with non-empty boundOuterColumns";
        assert (subQueryResults1.inputRow.equals((Object)Row.EMPTY) || subQueryResults2.inputRow.equals((Object)Row.EMPTY)) : "Can't merge two SubQueryResults with non-empty inputRow";
        Row mergedRow = subQueryResults1.inputRow;
        ObjectIntMap<OuterColumn> mergedBoundOuterColumns = subQueryResults1.boundOuterColumns;
        if (mergedRow.equals((Object)Row.EMPTY)) {
            mergedRow = subQueryResults2.inputRow;
        }
        if (mergedBoundOuterColumns.equals(EMPTY_OUTER_COLUMNS)) {
            mergedBoundOuterColumns = subQueryResults2.boundOuterColumns;
        }
        HashMap<SelectSymbol, Object> mergedValuesBySubQuery = new HashMap<SelectSymbol, Object>();
        mergedValuesBySubQuery.putAll(subQueryResults1.valuesBySubQuery);
        mergedValuesBySubQuery.putAll(subQueryResults2.valuesBySubQuery);
        SubQueryResults combinedSubQueryResults = new SubQueryResults(mergedValuesBySubQuery, mergedBoundOuterColumns);
        combinedSubQueryResults.bindOuterColumnInputRow(mergedRow);
        return combinedSubQueryResults;
    }
}

