/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.iterative;

import io.crate.common.collections.Lists;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.iterative.GroupReference;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface GroupReferenceResolver
extends UnaryOperator<LogicalPlan> {
    public static GroupReferenceResolver from(Function<GroupReference, LogicalPlan> resolver) {
        return node -> {
            if (node instanceof GroupReference) {
                GroupReference groupRef = (GroupReference)node;
                return (LogicalPlan)resolver.apply(groupRef);
            }
            throw new IllegalStateException("Node is not a GroupReference");
        };
    }

    public static LogicalPlan resolveFully(Function<LogicalPlan, LogicalPlan> resolver, LogicalPlan plan) {
        if (plan instanceof GroupReference) {
            GroupReference g = (GroupReference)plan;
            plan = resolver.apply(g);
        }
        if (plan.sources().isEmpty()) {
            return plan;
        }
        List sources = Lists.map(plan.sources(), x -> GroupReferenceResolver.resolveFully(resolver, x));
        return plan.replaceSources(sources);
    }
}

