/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.FunctionType;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.ProjectSet;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MoveFilterBeneathProjectSet
implements Rule<Filter> {
    private final Capture<ProjectSet> projectSetCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(ProjectSet.class).capturedAs(this.projectSetCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context ruleContext) {
        ProjectSet projectSet = captures.get(this.projectSetCapture);
        HashSet<Symbol> outputs = new HashSet<Symbol>();
        for (Symbol output : projectSet.standaloneOutputs()) {
            outputs.addAll(LogicalPlanner.extractColumns(output));
        }
        List<Symbol> queryParts = AndOperator.split(filter.query());
        ArrayList<Symbol> toPushDown = new ArrayList<Symbol>();
        ArrayList<Symbol> toKeep = new ArrayList<Symbol>();
        for (Symbol part : queryParts) {
            Set<Symbol> partColumns = LogicalPlanner.extractColumns(part);
            if (!part.any(MoveFilterBeneathProjectSet::isTableFunction) && partColumns.stream().allMatch(x -> Symbols.contains(outputs, x))) {
                toPushDown.add(part);
                continue;
            }
            toKeep.add(part);
        }
        if (toPushDown.isEmpty()) {
            return null;
        }
        if (toKeep.isEmpty()) {
            return Util.transpose(filter, projectSet);
        }
        LogicalPlan newProjectSet = projectSet.replaceSources(List.of(new Filter(projectSet.source(), AndOperator.join(toPushDown))));
        return new Filter(newProjectSet, AndOperator.join(toKeep));
    }

    private static boolean isTableFunction(Symbol s) {
        Function function;
        return s instanceof Function && (function = (Function)s).signature().getType() == FunctionType.TABLE;
    }
}

