/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.Union;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import java.util.List;

public final class MoveFilterBeneathUnion
implements Rule<Filter> {
    private final Capture<Union> unionCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(Union.class).capturedAs(this.unionCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context ruleContext) {
        Union union = captures.get(this.unionCapture);
        LogicalPlan lhs = union.sources().get(0);
        LogicalPlan rhs = union.sources().get(1);
        return union.replaceSources(List.of(MoveFilterBeneathUnion.createNewFilter(filter, lhs), MoveFilterBeneathUnion.createNewFilter(filter, rhs)));
    }

    private static Filter createNewFilter(Filter filter, LogicalPlan newSource) {
        Symbol newQuery = FieldReplacer.replaceFields(filter.query(), f -> {
            int idx = filter.source().outputs().indexOf(f);
            if (idx < 0) {
                throw new IllegalArgumentException("Field used in filter must be present in its source outputs." + String.valueOf(f) + " missing in " + String.valueOf(filter.source().outputs()));
            }
            return newSource.outputs().get(idx);
        });
        return new Filter(newSource, newQuery);
    }
}

