/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.planner.operators.Eval;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.NestedLoopJoin;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.statistics.Stats;

public class ReorderNestedLoopJoin
implements Rule<NestedLoopJoin> {
    private final Pattern<NestedLoopJoin> pattern = Pattern.typeOf(NestedLoopJoin.class).with(j -> !j.orderByWasPushedDown() && j.joinType().supportsInversion());

    @Override
    public Pattern<NestedLoopJoin> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(NestedLoopJoin nestedLoop, Captures captures, Rule.Context context) {
        boolean expectedRowsAvailable;
        PlanStats planStats = context.planStats();
        Stats lhStats = planStats.get(nestedLoop.lhs());
        Stats rhStats = planStats.get(nestedLoop.rhs());
        boolean bl = expectedRowsAvailable = lhStats.numDocs() != -1L && rhStats.numDocs() != -1L;
        if (expectedRowsAvailable && lhStats.numDocs() < rhStats.numDocs()) {
            return Eval.create(new NestedLoopJoin(nestedLoop.rhs(), nestedLoop.lhs(), nestedLoop.joinType().invert(), nestedLoop.joinCondition(), nestedLoop.isFiltered(), nestedLoop.orderByWasPushedDown(), nestedLoop.isRewriteNestedLoopJoinToHashJoinDone(), nestedLoop.lookUpJoin().invert()), nestedLoop.outputs());
        }
        return null;
    }
}

