/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.analyze.AnalyzedDeleteStatement;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.ddl.tables.DropPartitionsRequest;
import io.crate.execution.ddl.tables.TransportDropPartitionsAction;
import io.crate.execution.dml.BulkResponse;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.DeleteProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.MultiPhasePlan;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.WhereClauseOptimizer;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.ddl.DeleteAllPartitions;
import io.crate.planner.node.ddl.DeletePartitions;
import io.crate.planner.node.dml.DeleteById;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.symbol.Optimizer;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.jetbrains.annotations.VisibleForTesting;

public final class DeletePlanner {
    private DeletePlanner() {
    }

    public static Plan planDelete(AnalyzedDeleteStatement delete, SubqueryPlanner subqueryPlanner, PlannerContext context) {
        Plan plan = DeletePlanner.planDelete(delete, context);
        return MultiPhasePlan.createIfNeeded(plan, subqueryPlanner.planSubQueries(delete).uncorrelated());
    }

    private static Plan planDelete(AnalyzedDeleteStatement delete, PlannerContext context) {
        Input input;
        boolean hasNonPartitionReferences;
        DocTableRelation tableRel = delete.relation();
        DocTableInfo table = (DocTableInfo)tableRel.tableInfo();
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(context.nodeContext());
        WhereClauseOptimizer.DetailedQuery detailedQuery = WhereClauseOptimizer.optimize(normalizer, delete.query(), table, context.transactionContext(), context.nodeContext(), context.timeoutToken());
        Symbol query = detailedQuery.query();
        if (!detailedQuery.partitions().isEmpty() && !(hasNonPartitionReferences = query.any(s -> s instanceof Reference && !table.partitionedByColumns().contains(s)))) {
            return new DeletePartitions(table.ident(), detailedQuery.partitions());
        }
        if (detailedQuery.docKeys().isPresent() && detailedQuery.queryHasPkSymbolsOnly()) {
            return new DeleteById((DocTableInfo)tableRel.tableInfo(), detailedQuery.docKeys().get());
        }
        if (table.isPartitioned() && query instanceof Input && DataTypes.BOOLEAN.sanitizeValue((input = (Input)query).value()).booleanValue()) {
            return new DeleteAllPartitions(table.ident());
        }
        return new Delete(tableRel, detailedQuery);
    }

    @VisibleForTesting
    public static class Delete
    implements Plan {
        private final DocTableRelation table;
        private final WhereClauseOptimizer.DetailedQuery detailedQuery;

        public Delete(DocTableRelation table, WhereClauseOptimizer.DetailedQuery detailedQuery) {
            this.table = table;
            this.detailedQuery = detailedQuery;
        }

        @Override
        public Plan.StatementType type() {
            return Plan.StatementType.DELETE;
        }

        @Override
        public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
            WhereClause where = this.detailedQuery.toBoundWhereClause((DocTableInfo)this.table.tableInfo(), params, subQueryResults, plannerContext.transactionContext(), plannerContext.nodeContext(), plannerContext.clusterState().metadata());
            if (!(where.partitions().isEmpty() || where.hasQuery() && !Literal.BOOLEAN_TRUE.equals(where.query()))) {
                ArrayList<PartitionName> partitionValues = new ArrayList<PartitionName>(where.partitions().size());
                for (String partition : where.partitions()) {
                    partitionValues.add(new PartitionName(this.table.relationName(), IndexName.decode(partition).partitionIdent()));
                }
                dependencies.client().execute(TransportDropPartitionsAction.ACTION, new DropPartitionsRequest(this.table.relationName(), partitionValues)).whenComplete(new OneRowActionListener<AcknowledgedResponse>(consumer, ignoredResponse -> Row1.ROW_COUNT_UNKNOWN));
                return;
            }
            ExecutionPlan executionPlan = Delete.deleteByQuery(this.table, plannerContext, where);
            NodeOperationTree nodeOpTree = NodeOperationTreeGenerator.fromPlan(executionPlan, dependencies.localNodeId());
            dependencies.phasesTaskFactory().create(plannerContext.jobId(), Collections.singletonList(nodeOpTree)).execute(consumer, plannerContext.transactionContext());
        }

        @Override
        public CompletableFuture<BulkResponse> executeBulk(DependencyCarrier executor, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
            ArrayList<NodeOperationTree> nodeOperationTreeList = new ArrayList<NodeOperationTree>(bulkParams.size());
            for (Row params : bulkParams) {
                WhereClause where = this.detailedQuery.toBoundWhereClause((DocTableInfo)this.table.tableInfo(), params, subQueryResults, plannerContext.transactionContext(), executor.nodeContext(), plannerContext.clusterState().metadata());
                ExecutionPlan executionPlan = Delete.deleteByQuery(this.table, plannerContext, where);
                nodeOperationTreeList.add(NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId()));
            }
            return executor.phasesTaskFactory().create(plannerContext.jobId(), nodeOperationTreeList).executeBulk(plannerContext.transactionContext());
        }

        private static ExecutionPlan deleteByQuery(DocTableRelation table, PlannerContext context, WhereClause where) {
            DocTableInfo tableInfo = (DocTableInfo)table.tableInfo();
            Reference idReference = Objects.requireNonNull(tableInfo.getReference(SysColumns.ID.COLUMN), "Table has to have a _id reference");
            DeleteProjection deleteProjection = new DeleteProjection(new InputColumn(0, idReference.valueType()));
            CoordinatorSessionSettings sessionSettings = context.transactionContext().sessionSettings();
            Routing routing = context.allocateRouting(tableInfo, where, RoutingProvider.ShardSelection.PRIMARIES, sessionSettings);
            RoutedCollectPhase collectPhase = new RoutedCollectPhase(context.jobId(), context.nextExecutionPhaseId(), "collect", routing, tableInfo.rowGranularity(), List.of(idReference), List.of(deleteProjection), Optimizer.optimizeCasts(where.queryOrFallback(), context), DistributionInfo.DEFAULT_BROADCAST);
            Collect collect = new Collect(collectPhase, -1, 0, 1, 1, null);
            return Merge.ensureOnHandler(collect, context, Collections.singletonList(MergeCountProjection.INSTANCE));
        }
    }
}

