/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.analyze.AnalyzedSetSessionAuthorizationStatement;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.role.Role;
import io.crate.role.Roles;

public class SetSessionAuthorizationPlan
implements Plan {
    private final AnalyzedSetSessionAuthorizationStatement setSessionAuthorization;
    private final Roles roles;

    public SetSessionAuthorizationPlan(AnalyzedSetSessionAuthorizationStatement setSessionAuthorization, Roles roles) {
        this.setSessionAuthorization = setSessionAuthorization;
        this.roles = roles;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        CoordinatorSessionSettings sessionSettings = plannerContext.transactionContext().sessionSettings();
        String userName = this.setSessionAuthorization.user();
        Role user = userName != null ? this.roles.getUser(userName) : sessionSettings.authenticatedUser();
        sessionSettings.setSessionUser(user);
        consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
    }
}

