/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import io.crate.auth.Credentials;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class Headers {
    private static final Pattern USER_AGENT_BROWSER_PATTERN = Pattern.compile("(Mozilla|Chrome|Safari|Opera|Android|AppleWebKit)+?[/\\s][\\d.]+");

    static boolean isBrowser(@Nullable String headerValue) {
        if (headerValue == null) {
            return false;
        }
        String engine = headerValue.split("\\s+")[0];
        return USER_AGENT_BROWSER_PATTERN.matcher(engine).matches();
    }

    static boolean isAcceptJson(String headerValue) {
        return headerValue != null && headerValue.contains("application/json");
    }

    public static boolean isCloseConnection(FullHttpRequest request) {
        HttpHeaders headers = request.headers();
        return HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.CONNECTION)) || request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)headers.get((CharSequence)HttpHeaderNames.CONNECTION));
    }

    public static void setKeepAlive(HttpVersion httpVersion, FullHttpResponse resp) {
        if (httpVersion.equals((Object)HttpVersion.HTTP_1_0)) {
            resp.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Keep-Alive");
        }
    }

    public static Credentials extractCredentialsFromHttpAuthHeader(String authHeaderValue) {
        if (authHeaderValue == null || authHeaderValue.isEmpty()) {
            return new Credentials(null, null);
        }
        String[] splitHeader = authHeaderValue.split(" ");
        assert (splitHeader.length == 2) : "Header must contain only authentication scheme and base64 encoded value, separated by a whitespace";
        return switch (splitHeader[0].toLowerCase(Locale.ENGLISH)) {
            case "basic" -> Headers.extractCredentialsFromHttpBasicAuthHeader(splitHeader[1]);
            case "bearer" -> new Credentials(splitHeader[1]);
            default -> throw new IllegalArgumentException("Only basic or bearer HTTP Authentication schemes are allowed.");
        };
    }

    private static Credentials extractCredentialsFromHttpBasicAuthHeader(String valueWithoutBasePrefix) {
        String username;
        char[] password = null;
        String decodedCreds = new String(Base64.getDecoder().decode(valueWithoutBasePrefix), StandardCharsets.UTF_8);
        int idx = decodedCreds.indexOf(58);
        if (idx < 0) {
            username = decodedCreds;
        } else {
            username = decodedCreds.substring(0, idx);
            String passwdStr = decodedCreds.substring(idx + 1);
            if (!passwdStr.isEmpty()) {
                password = passwdStr.toCharArray();
            }
        }
        return new Credentials(username, password);
    }
}

