/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.AccessControl;
import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.protocols.postgres.FormatCodes;
import io.crate.protocols.postgres.PGError;
import io.crate.protocols.postgres.PGErrorStatus;
import io.crate.protocols.postgres.TransactionState;
import io.crate.protocols.postgres.types.PGType;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.types.DataType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class Messages {
    private static final Logger LOGGER = LogManager.getLogger(Messages.class);
    private static final byte[] METHOD_NAME_CLIENT_AUTH = "ClientAuthentication".getBytes(StandardCharsets.UTF_8);

    private Messages() {
    }

    public static ChannelFuture sendAuthenticationOK(Channel channel) {
        ByteBuf buffer = channel.alloc().buffer(9);
        buffer.writeByte(82);
        buffer.writeInt(8);
        buffer.writeInt(0);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentAuthenticationOK"));
        }
        return channelFuture;
    }

    static ChannelFuture sendCommandComplete(Channel channel, String query, long rowCount) {
        Object commandTag = "BEGIN".equals(query = query.trim().split(" ", 2)[0].toUpperCase(Locale.ENGLISH)) ? "BEGIN" : ("INSERT".equals(query) ? "INSERT 0 " + rowCount : query + " " + rowCount);
        byte[] commandTagBytes = ((String)commandTag).getBytes(StandardCharsets.UTF_8);
        int length = 4 + commandTagBytes.length + 1;
        ByteBuf buffer = channel.alloc().buffer(length + 1);
        buffer.writeByte(67);
        buffer.writeInt(length);
        Messages.writeCString(buffer, commandTagBytes);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentCommandComplete"));
        }
        return channelFuture;
    }

    static ChannelFuture sendReadyForQuery(Channel channel, TransactionState transactionState) {
        ByteBuf buffer = channel.alloc().buffer(6);
        buffer.writeByte(90);
        buffer.writeInt(5);
        buffer.writeByte(transactionState.code());
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentReadyForQuery"));
        }
        return channelFuture;
    }

    static void sendParameterStatus(Channel channel, String name, String value) {
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        int length = 4 + nameBytes.length + 1 + valueBytes.length + 1;
        ByteBuf buffer = channel.alloc().buffer(length + 1);
        buffer.writeByte(83);
        buffer.writeInt(length);
        Messages.writeCString(buffer, nameBytes);
        Messages.writeCString(buffer, valueBytes);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentParameterStatus {}={}", (Object)name, (Object)value));
        }
    }

    static void sendAuthenticationError(Channel channel, String message) {
        LOGGER.warn(message);
        byte[] msg = message.getBytes(StandardCharsets.UTF_8);
        byte[] errorCode = PGErrorStatus.INVALID_AUTHORIZATION_SPECIFICATION.code().getBytes(StandardCharsets.UTF_8);
        Messages.sendErrorResponse(channel, message, msg, PGError.Severity.FATAL.bytes(), null, null, METHOD_NAME_CLIENT_AUTH, errorCode);
    }

    static ChannelFuture sendErrorResponse(Channel channel, AccessControl accessControl, Throwable throwable) {
        return Messages.sendErrorResponse(channel, accessControl, throwable, PGError.Severity.ERROR);
    }

    static ChannelFuture sendErrorResponse(Channel channel, AccessControl accessControl, Throwable throwable, PGError.Severity severity) {
        PGError error = PGError.fromThrowable(SQLExceptions.prepareForClientTransmission(accessControl, throwable));
        ByteBuf buffer = channel.alloc().buffer();
        buffer.writeByte(69);
        buffer.writeInt(0);
        buffer.writeByte(83);
        Messages.writeCString(buffer, severity.bytes());
        buffer.writeByte(77);
        Messages.writeCString(buffer, error.message().getBytes(StandardCharsets.UTF_8));
        buffer.writeByte(67);
        Messages.writeCString(buffer, error.status().code().getBytes(StandardCharsets.UTF_8));
        StackTraceElement[] stackTrace = error.throwable().getStackTrace();
        if (stackTrace.length > 0) {
            int lineNumber;
            String methodName;
            StackTraceElement first = stackTrace[0];
            String fileName = first.getFileName();
            if (fileName != null) {
                buffer.writeByte(70);
                Messages.writeCString(buffer, fileName.getBytes(StandardCharsets.UTF_8));
            }
            if ((methodName = first.getMethodName()) != null) {
                buffer.writeByte(82);
                Messages.writeCString(buffer, methodName.getBytes(StandardCharsets.UTF_8));
            }
            if ((lineNumber = first.getLineNumber()) >= 0) {
                buffer.writeByte(76);
                Messages.writeCString(buffer, String.valueOf(lineNumber).getBytes(StandardCharsets.UTF_8));
            }
            buffer.writeByte(87);
            StringBuilder sb = new StringBuilder();
            int cap = Math.min(stackTrace.length, 20);
            for (int i = 0; i < cap; ++i) {
                StackTraceElement stackTraceElement = stackTrace[i];
                sb.append(stackTraceElement.toString());
                sb.append("\n");
            }
            Messages.writeCString(buffer, sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        buffer.writeByte(0);
        buffer.setInt(1, buffer.writerIndex() - 1);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentErrorResponse msg={}", (Object)error.message()));
        }
        return channelFuture;
    }

    private static ChannelFuture sendErrorResponse(Channel channel, String message, byte[] msg, byte[] severity, byte[] lineNumber, byte[] fileName, byte[] methodName, byte[] errorCode) {
        int length = 5 + (severity.length + 1) + 1 + (msg.length + 1) + 1 + (errorCode.length + 1) + (fileName != null ? 1 + (fileName.length + 1) : 0) + (lineNumber != null ? 1 + (lineNumber.length + 1) : 0) + (methodName != null ? 1 + (methodName.length + 1) : 0) + 1;
        ByteBuf buffer = channel.alloc().buffer(length + 1);
        buffer.writeByte(69);
        buffer.writeInt(length);
        buffer.writeByte(83);
        Messages.writeCString(buffer, severity);
        buffer.writeByte(77);
        Messages.writeCString(buffer, msg);
        buffer.writeByte(67);
        Messages.writeCString(buffer, errorCode);
        if (fileName != null) {
            buffer.writeByte(70);
            Messages.writeCString(buffer, fileName);
        }
        if (lineNumber != null) {
            buffer.writeByte(76);
            Messages.writeCString(buffer, lineNumber);
        }
        if (methodName != null) {
            buffer.writeByte(82);
            Messages.writeCString(buffer, methodName);
        }
        buffer.writeByte(0);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentErrorResponse msg={}", (Object)message));
        }
        return channelFuture;
    }

    static ChannelFuture sendDataRow(Channel channel, Row row, List<PGType<?>> columnTypes, @Nullable FormatCodes.FormatCode[] formatCodes) {
        int length = 6;
        assert (columnTypes.size() == row.numColumns()) : "Number of columns in the row must match number of columnTypes. Row: " + String.valueOf(row) + " types: " + String.valueOf(columnTypes);
        ByteBuf buffer = channel.alloc().buffer();
        buffer.writeByte(68);
        buffer.writeInt(0);
        buffer.writeShort(row.numColumns());
        block6: for (int i = 0; i < row.numColumns(); ++i) {
            Object value;
            PGType<?> pgType = columnTypes.get(i);
            try {
                value = row.get(i);
            }
            catch (Exception e) {
                buffer.release();
                throw e;
            }
            if (value == null) {
                buffer.writeInt(-1);
                length += 4;
                continue;
            }
            FormatCodes.FormatCode formatCode = FormatCodes.getFormatCode(formatCodes, i);
            switch (formatCode) {
                case TEXT: {
                    length += pgType.writeAsText(buffer, value);
                    continue block6;
                }
                case BINARY: {
                    length += pgType.writeAsBinary(buffer, value);
                    continue block6;
                }
                default: {
                    buffer.release();
                    throw new AssertionError((Object)("Unrecognized formatCode: " + String.valueOf((Object)formatCode)));
                }
            }
        }
        buffer.setInt(1, length);
        return channel.write((Object)buffer);
    }

    static void writeCString(ByteBuf buffer, byte[] valBytes) {
        buffer.writeBytes(valBytes);
        buffer.writeByte(0);
    }

    static void sendParameterDescription(Channel channel, DataType<?>[] parameters) {
        int messageByteSize = 6 + parameters.length * 4;
        ByteBuf buffer = channel.alloc().buffer(messageByteSize);
        buffer.writeByte(116);
        buffer.writeInt(messageByteSize);
        if (parameters.length > Short.MAX_VALUE) {
            buffer.release();
            throw new IllegalArgumentException("Too many parameters. Max supported: 32767");
        }
        buffer.writeShort(parameters.length);
        for (DataType<?> dataType : parameters) {
            int pgTypeId = PGTypes.get(dataType).oid();
            buffer.writeInt(pgTypeId);
        }
        channel.write((Object)buffer);
    }

    private static boolean isRefWithPosition(Symbol symbol) {
        Reference ref;
        return symbol instanceof Reference && (ref = (Reference)symbol).position() != 0;
    }

    static void sendRowDescription(Channel channel, Collection<Symbol> columns, List<String> columnNames, @Nullable FormatCodes.FormatCode[] formatCodes, @Nullable RelationInfo relation) {
        assert (columns.size() == columnNames.size()) : "Size of columns must match size of columnNames";
        int length = 6;
        int columnSize = 18;
        ByteBuf buffer = channel.alloc().buffer(length + columns.size() * (10 + columnSize));
        buffer.writeByte(84);
        buffer.writeInt(0);
        buffer.writeShort(columns.size());
        int tableOid = 0;
        if (relation != null && columns.stream().allMatch(Messages::isRefWithPosition)) {
            tableOid = OidHash.relationOid(relation);
        }
        int idx = 0;
        for (Symbol column : columns) {
            String name = columnNames.get(idx);
            byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
            length += nameBytes.length + 1;
            length += columnSize;
            Messages.writeCString(buffer, nameBytes);
            buffer.writeInt(tableOid);
            if (column instanceof Reference) {
                Reference ref = (Reference)column;
                int position = ref.position();
                buffer.writeShort(position);
            } else {
                buffer.writeShort(0);
            }
            PGType<?> pgType = PGTypes.get(column.valueType());
            buffer.writeInt(pgType.oid());
            buffer.writeShort((int)pgType.typeLen());
            buffer.writeInt(pgType.typeMod());
            buffer.writeShort(FormatCodes.getFormatCode(formatCodes, idx).ordinal());
            ++idx;
        }
        buffer.setInt(1, length);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentRowDescription"));
        }
    }

    static void sendParseComplete(Channel channel) {
        Messages.sendShortMsg(channel, '1', "sentParseComplete");
    }

    static void sendBindComplete(Channel channel) {
        Messages.sendShortMsg(channel, '2', "sentBindComplete");
    }

    static void sendEmptyQueryResponse(Channel channel) {
        Messages.sendShortMsg(channel, 'I', "sentEmptyQueryResponse");
    }

    static void sendNoData(Channel channel) {
        Messages.sendShortMsg(channel, 'n', "sentNoData");
    }

    private static ChannelFuture sendShortMsg(Channel channel, char msgType, String traceLogMsg) {
        ByteBuf buffer = channel.alloc().buffer(5);
        buffer.writeByte((int)msgType);
        buffer.writeInt(4);
        ChannelFuture channelFuture = channel.write((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace(traceLogMsg));
        }
        return channelFuture;
    }

    static ChannelFuture sendPortalSuspended(Channel channel) {
        return Messages.sendShortMsg(channel, 's', "sentPortalSuspended");
    }

    static void sendCloseComplete(Channel channel) {
        Messages.sendShortMsg(channel, '3', "sentCloseComplete");
    }

    static void sendAuthenticationCleartextPassword(Channel channel) {
        ByteBuf buffer = channel.alloc().buffer(9);
        buffer.writeByte(82);
        buffer.writeInt(8);
        buffer.writeInt(3);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentAuthenticationCleartextPassword"));
        }
    }

    static void sendKeyData(Channel channel, int pid, int secretKey) {
        ByteBuf buffer = channel.alloc().buffer(13);
        buffer.writeByte(75);
        buffer.writeInt(12);
        buffer.writeInt(pid);
        buffer.writeInt(secretKey);
        ChannelFuture channelFuture = channel.writeAndFlush((Object)buffer);
        if (LOGGER.isTraceEnabled()) {
            channelFuture.addListener(future -> LOGGER.trace("sentKeyData"));
        }
    }
}

