/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.exceptions.AmbiguousColumnAliasException;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.DuplicateKeyException;
import io.crate.exceptions.InvalidSchemaNameException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SQLExceptions;
import io.crate.exceptions.UnsupportedFunctionException;
import io.crate.exceptions.UserDefinedFunctionUnknownException;
import io.crate.protocols.postgres.PGErrorStatus;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.ElasticsearchException;
import org.jetbrains.annotations.Nullable;

public class PGError {
    private final PGErrorStatus status;
    private final String message;
    @Nullable
    private final Throwable throwable;

    public PGError(PGErrorStatus status, String message, @Nullable Throwable throwable) {
        this.status = status;
        this.message = message;
        this.throwable = throwable;
    }

    public PGErrorStatus status() {
        return this.status;
    }

    @Nullable
    public Throwable throwable() {
        return this.throwable;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        return "PGError{status=" + String.valueOf((Object)this.status) + ", message='" + this.message + "', throwable=" + String.valueOf(this.throwable) + "}";
    }

    public static PGError fromThrowable(Throwable throwable) {
        PGErrorStatus status = PGErrorStatus.INTERNAL_ERROR;
        if (throwable instanceof IllegalArgumentException || throwable instanceof UnsupportedOperationException || throwable instanceof UnsupportedFunctionException) {
            status = PGErrorStatus.FEATURE_NOT_SUPPORTED;
        } else if (throwable instanceof DuplicateKeyException) {
            status = PGErrorStatus.UNIQUE_VIOLATION;
        } else if (throwable instanceof RelationUnknown) {
            status = PGErrorStatus.UNDEFINED_TABLE;
        } else if (throwable instanceof ColumnUnknownException) {
            status = PGErrorStatus.UNDEFINED_COLUMN;
        } else if (throwable instanceof RelationAlreadyExists) {
            status = PGErrorStatus.DUPLICATE_TABLE;
        } else if (throwable instanceof AmbiguousColumnException) {
            status = PGErrorStatus.AMBIGUOUS_COLUMN;
        } else if (throwable instanceof InvalidSchemaNameException) {
            status = PGErrorStatus.INVALID_SCHEMA_NAME;
        } else if (throwable instanceof AmbiguousColumnAliasException) {
            status = PGErrorStatus.AMBIGUOUS_ALIAS;
        } else if (throwable instanceof UserDefinedFunctionUnknownException) {
            status = PGErrorStatus.UNDEFINED_FUNCTION;
        } else if (throwable instanceof ElasticsearchException) {
            ElasticsearchException ex = (ElasticsearchException)throwable;
            status = ex.pgErrorStatus();
        }
        return new PGError(status, SQLExceptions.messageOf(throwable), throwable);
    }

    public static enum Severity {
        ERROR,
        FATAL;

        private final byte[] bytes = this.name().getBytes(StandardCharsets.UTF_8);

        public byte[] bytes() {
            return this.bytes;
        }
    }
}

