/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.types.Regclass;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class RegclassType
extends PGType<Regclass> {
    static final int OID = 2205;
    private static final int TYPE_LEN = 4;
    private static final int TYPE_MOD = -1;
    public static final RegclassType INSTANCE = new RegclassType();

    private RegclassType() {
        super(2205, 4, -1, "regclass");
    }

    @Override
    public int typArray() {
        return PGArray.REGCLASS_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, Regclass value) {
        buffer.writeInt(4);
        buffer.writeInt(value.oid());
        return 8;
    }

    @Override
    public Regclass readBinaryValue(ByteBuf buffer, int valueLength) {
        int oid = buffer.readInt();
        return new Regclass(oid, String.valueOf(oid));
    }

    @Override
    byte[] encodeAsUTF8Text(Regclass value) {
        return String.valueOf(value.oid()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Regclass decodeUTF8Text(byte[] bytes) {
        String oidStr = new String(bytes, StandardCharsets.UTF_8);
        try {
            int oid = Integer.parseInt(oidStr);
            return new Regclass(oid, oidStr);
        }
        catch (NumberFormatException e) {
            IndexParts indexParts = IndexName.decode(oidStr);
            return Regclass.fromRelationName(indexParts.toRelationName());
        }
    }
}

