/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import java.io.IOException;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.RemoteClusterAwareRequest;

public class RestoreShardRequest
extends SingleShardRequest
implements RemoteClusterAwareRequest {
    private final String restoreUUID;
    private final DiscoveryNode node;
    private final ShardId shardId;
    private final String subscriberClusterName;

    public RestoreShardRequest(String restoreUUID, DiscoveryNode node, ShardId shardId, String subscriberClusterName) {
        super(shardId.getIndexName());
        this.restoreUUID = restoreUUID;
        this.node = node;
        this.shardId = shardId;
        this.subscriberClusterName = subscriberClusterName;
    }

    public RestoreShardRequest(StreamInput in) throws IOException {
        super(in);
        this.restoreUUID = in.readString();
        this.node = new DiscoveryNode(in);
        this.shardId = new ShardId(in);
        this.subscriberClusterName = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.restoreUUID);
        this.node.writeTo(out);
        this.shardId.writeTo(out);
        out.writeString(this.subscriberClusterName);
    }

    @Override
    public DiscoveryNode getPreferredTargetNode() {
        return this.node;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String subscriberClusterName() {
        return this.subscriberClusterName;
    }

    public String restoreUUID() {
        return this.restoreUUID;
    }

    public String toString() {
        return "RestoreShardRequest{restoreUUID='" + this.restoreUUID + "', node=" + String.valueOf(this.node) + ", shardId=" + String.valueOf(this.shardId) + ", subscriberClusterName='" + this.subscriberClusterName + "', index='" + this.index + "'}";
    }
}

