/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.exceptions.RelationUnknown;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.exceptions.PublicationUnknownException;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import io.crate.sql.tree.AlterPublication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportAlterPublication
extends TransportMasterNodeAction<Request, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private static final Logger LOGGER = LogManager.getLogger(TransportAlterPublication.class);

    @Inject
    public TransportAlterPublication(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, Request::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(final Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        ClusterStateUpdateTask updateTask = new ClusterStateUpdateTask(this){
            final /* synthetic */ TransportAlterPublication this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                PublicationsMetadata oldMetadata = (PublicationsMetadata)mdBuilder.getCustom("publications");
                if (oldMetadata == null) {
                    throw new PublicationUnknownException(request.name);
                }
                Publication publication = oldMetadata.publications().get(request.name);
                if (publication != null) {
                    Publication newPublication = TransportAlterPublication.updatePublication(request, currentMetadata, publication);
                    PublicationsMetadata newMetadata = PublicationsMetadata.newInstance(oldMetadata);
                    newMetadata.publications().put(request.name, newPublication);
                    assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
                    mdBuilder.putCustom("publications", newMetadata);
                    return ClusterState.builder(currentState).metadata(mdBuilder).build();
                }
                throw new PublicationUnknownException(request.name);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new AcknowledgedResponse(true));
            }

            @Override
            public void onFailure(String source, Exception e) {
                if (LOGGER.isTraceEnabled()) {
                    this.this$0.logger.trace("Error while trying to alter publication " + request.name, (Throwable)e);
                }
                listener.onFailure(e);
            }
        };
        this.clusterService.submitStateUpdateTask("alter-publication", updateTask);
    }

    @VisibleForTesting
    static Publication updatePublication(Request request, Metadata currentMetadata, Publication oldPublication) {
        for (RelationName relation : request.tables) {
            if (currentMetadata.getRelation(relation) != null) continue;
            throw new RelationUnknown(relation);
        }
        HashSet<Object> tables = new HashSet<RelationName>();
        switch (request.operation) {
            case SET: {
                tables = new HashSet<RelationName>(request.tables);
                break;
            }
            case ADD: {
                tables.addAll(oldPublication.tables());
                tables.addAll(request.tables);
                break;
            }
            case DROP: {
                oldPublication.tables().stream().filter(relationName -> !request.tables.contains(relationName)).forEach(tables::add);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Alter publication operation '" + String.valueOf(request.operation) + "' is not supported");
            }
        }
        return new Publication(oldPublication.owner(), oldPublication.isForAllTables(), new ArrayList<Object>(tables));
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:replication/logical/publication/alter";

        private Action() {
            super(NAME);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String name;
        private final AlterPublication.Operation operation;
        private final List<RelationName> tables;

        public Request(String name, AlterPublication.Operation operation, List<RelationName> tables) {
            this.name = name;
            this.operation = operation;
            this.tables = tables;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.operation = AlterPublication.Operation.VALUES[in.readVInt()];
            this.tables = in.readList(RelationName::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeVInt(this.operation.ordinal());
            out.writeList(this.tables);
        }
    }
}

