/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;

public class Publication
implements Writeable {
    private static final Logger LOGGER = LogManager.getLogger(Publication.class);
    private final String owner;
    private final boolean forAllTables;
    private final List<RelationName> tables;

    public Publication(String owner, boolean forAllTables, List<RelationName> tables) {
        assert (!forAllTables || forAllTables && tables.isEmpty()) : "If forAllTables is true, tables must be empty";
        this.owner = owner;
        this.forAllTables = forAllTables;
        this.tables = tables;
    }

    Publication(StreamInput in) throws IOException {
        this.owner = in.readString();
        this.forAllTables = in.readBoolean();
        int size = in.readVInt();
        this.tables = new ArrayList<RelationName>(size);
        for (int i = 0; i < size; ++i) {
            this.tables.add(RelationName.fromIndexName(in.readString()));
        }
    }

    public String owner() {
        return this.owner;
    }

    public boolean isForAllTables() {
        return this.forAllTables;
    }

    public List<RelationName> tables() {
        return this.tables;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.owner);
        out.writeBoolean(this.forAllTables);
        out.writeVInt(this.tables.size());
        for (RelationName table : this.tables) {
            out.writeString(table.indexNameOrAlias());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Publication that = (Publication)o;
        return this.forAllTables == that.forAllTables && this.owner.equals(that.owner) && this.tables.equals(that.tables);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.tables, this.forAllTables);
    }

    public String toString() {
        return "Publication{forAllTables=" + this.forAllTables + ", owner=" + this.owner + ", tables=" + String.valueOf(this.tables) + "}";
    }

    public Metadata.Builder resolveCurrentRelations(ClusterState state, Roles roles, Role publicationOwner, Role subscriber, String publicationName, Metadata.Builder metadataBuilder) {
        Metadata metadata = state.metadata();
        Predicate<RelationName> relationFilter = relationName -> {
            if (!Publication.userCanPublish(roles, relationName, publicationOwner, publicationName)) {
                return false;
            }
            return Publication.subscriberCanRead(roles, relationName, subscriber, publicationName);
        };
        Predicate<Index> indexFilter = index -> {
            IndexMetadata indexMetadata = metadata.index((Index)index);
            if (indexMetadata != null) {
                IndexRoutingTable routingTable = state.routingTable().index((Index)index);
                assert (routingTable != null) : "routingTable must not be null";
                return routingTable.allPrimaryShardsActive();
            }
            return false;
        };
        if (this.isForAllTables()) {
            for (RelationMetadata.Table table : metadata.relations(RelationMetadata.Table.class)) {
                if (!relationFilter.test(table.name())) continue;
                Publication.addRelation(metadata, metadataBuilder, table, indexFilter);
            }
        } else {
            for (RelationName relationName2 : this.tables) {
                if (!relationFilter.test(relationName2)) continue;
                RelationMetadata.Table table = (RelationMetadata.Table)metadata.getRelation(relationName2);
                if (table == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Table {} not found in metadata, skipping publication resolution for it.", (Object)relationName2);
                    continue;
                }
                Publication.addRelation(metadata, metadataBuilder, table, indexFilter);
            }
        }
        return metadataBuilder;
    }

    private static void addRelation(Metadata currentMetadata, Metadata.Builder metadataBuilder, RelationMetadata.Table table, Predicate<Index> indexFilter) {
        metadataBuilder.setRelation(table);
        for (IndexMetadata indexMetadata : currentMetadata.getIndices(table.name(), List.of(), true, im -> im)) {
            IndexMetadata.Builder publishedIndexMetadata = IndexMetadata.builder(indexMetadata);
            if (!indexFilter.test(indexMetadata.getIndex())) {
                publishedIndexMetadata.settings(Settings.builder().put(indexMetadata.getSettings()).put(LogicalReplicationSettings.REPLICATION_INDEX_ROUTING_ACTIVE.getKey(), false));
            }
            metadataBuilder.put(publishedIndexMetadata);
        }
    }

    private static boolean subscriberCanRead(Roles roles, RelationName relationName, Role subscriber, String publicationName) {
        boolean canRead = roles.hasPrivilege(subscriber, Permission.DQL, Securable.TABLE, relationName.fqn());
        if (!canRead && LOGGER.isInfoEnabled()) {
            LOGGER.info("User {} subscribed to the publication {} doesn't have DQL privilege on the table {}, this table will not be replicated.", (Object)subscriber.name(), (Object)publicationName, (Object)relationName.fqn());
        }
        return canRead;
    }

    private static boolean userCanPublish(Roles roles, RelationName relationName, Role publicationOwner, String publicationName) {
        for (Permission permission : Permission.READ_WRITE_DEFINE) {
            if (roles.hasPrivilege(publicationOwner, permission, Securable.TABLE, relationName.fqn())) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("User {} owning publication {} doesn't have {} privilege on the table {}, this table will not be replicated.", (Object)publicationOwner.name(), (Object)publicationName, (Object)permission.name(), (Object)relationName.fqn());
            }
            return false;
        }
        return true;
    }
}

