/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.metadata.Publication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public class PublicationsMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "publications";
    private final Map<String, Publication> publicationByName;

    public static PublicationsMetadata newInstance(@Nullable PublicationsMetadata instance) {
        if (instance == null) {
            return new PublicationsMetadata();
        }
        return new PublicationsMetadata(new HashMap<String, Publication>(instance.publicationByName));
    }

    public PublicationsMetadata(Map<String, Publication> publicationByName) {
        this.publicationByName = publicationByName;
    }

    public PublicationsMetadata(StreamInput in) throws IOException {
        int numPubs = in.readVInt();
        this.publicationByName = new HashMap<String, Publication>(numPubs);
        for (int i = 0; i < numPubs; ++i) {
            this.publicationByName.put(in.readString(), new Publication(in));
        }
    }

    public PublicationsMetadata() {
        this(new HashMap<String, Publication>());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.publicationByName.size());
        for (Map.Entry<String, Publication> entry : this.publicationByName.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT, Metadata.XContentContext.API);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_4_7_0;
    }

    public static PublicationsMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Publication> publications = new HashMap<String, Publication>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME && parser.currentName().equals(TYPE)) {
            if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                    String name = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
                    String owner = null;
                    boolean forAllTables = false;
                    ArrayList<RelationName> tables = new ArrayList<RelationName>();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if ("owner".equals(parser.currentName())) {
                            parser.nextToken();
                            owner = parser.textOrNull();
                        }
                        if ("forAllTables".equals(parser.currentName())) {
                            parser.nextToken();
                            forAllTables = parser.booleanValue();
                        }
                        if (!"tables".equals(parser.currentName())) continue;
                        parser.nextToken();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            tables.add(RelationName.fromIndexName(parser.text()));
                        }
                    }
                    if (owner == null) {
                        throw new ElasticsearchParseException("failed to parse publication, expected field 'owner' in object", new Object[0]);
                    }
                    publications.put(name, new Publication(owner, forAllTables, tables));
                }
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ElasticsearchParseException("failed to parse publications, expected an object token at the end", new Object[0]);
            }
        }
        return new PublicationsMetadata(publications);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationsMetadata that = (PublicationsMetadata)o;
        return this.publicationByName.equals(that.publicationByName);
    }

    public int hashCode() {
        return Objects.hash(this.publicationByName);
    }

    public Map<String, Publication> publications() {
        return this.publicationByName;
    }

    public String toString() {
        return "PublicationsMetadata{" + String.valueOf(this.publicationByName) + "}";
    }

    public boolean isPublished(RelationName relation) {
        for (Publication publication : this.publications().values()) {
            if (!publication.isForAllTables() && !publication.tables().contains(relation)) continue;
            return true;
        }
        return false;
    }
}

