/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.metadata.ConnectionInfo;
import io.crate.replication.logical.metadata.Subscription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public class SubscriptionsMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "subscriptions";
    private static final SubscriptionsMetadata EMPTY = new SubscriptionsMetadata(Map.of());
    private final Map<String, Subscription> subscriptionByName;

    public static SubscriptionsMetadata newInstance(SubscriptionsMetadata instance) {
        if (instance == null) {
            return new SubscriptionsMetadata();
        }
        return new SubscriptionsMetadata(new HashMap<String, Subscription>(instance.subscriptionByName));
    }

    public static SubscriptionsMetadata get(Metadata metadata) {
        SubscriptionsMetadata subscriptionsMetadata = (SubscriptionsMetadata)metadata.custom(TYPE);
        if (subscriptionsMetadata == null) {
            return EMPTY;
        }
        return subscriptionsMetadata;
    }

    public SubscriptionsMetadata(Map<String, Subscription> subscriptionByName) {
        this.subscriptionByName = subscriptionByName;
    }

    public SubscriptionsMetadata(StreamInput in) throws IOException {
        int numPubs = in.readVInt();
        this.subscriptionByName = new HashMap<String, Subscription>(numPubs);
        for (int i = 0; i < numPubs; ++i) {
            this.subscriptionByName.put(in.readString(), new Subscription(in));
        }
    }

    public SubscriptionsMetadata() {
        this(new HashMap<String, Subscription>());
    }

    @Nullable
    public Subscription get(String subscriptionName) {
        return this.subscriptionByName.get(subscriptionName);
    }

    public Map<String, Subscription> subscription() {
        return this.subscriptionByName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.subscriptionByName.size());
        for (Map.Entry<String, Subscription> entry : this.subscriptionByName.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT, Metadata.XContentContext.API);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_4_7_0;
    }

    public static SubscriptionsMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Subscription> subscriptions = new HashMap<String, Subscription>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME && parser.currentName().equals(TYPE)) {
            if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
                while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                    String name = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
                    String owner = null;
                    ConnectionInfo connectionInfo = null;
                    Settings settings = null;
                    ArrayList<String> publications = new ArrayList<String>();
                    HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        if ("owner".equals(parser.currentName())) {
                            parser.nextToken();
                            owner = parser.textOrNull();
                        }
                        if ("connection_info".equals(parser.currentName()) && parser.nextToken() == XContentParser.Token.START_OBJECT) {
                            ArrayList<String> hosts = new ArrayList<String>();
                            Settings connSettings = null;
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                if ("hosts".equals(parser.currentName())) {
                                    parser.nextToken();
                                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                        hosts.add(parser.text());
                                    }
                                }
                                if (!"settings".equals(parser.currentName())) continue;
                                parser.nextToken();
                                connSettings = Settings.fromXContent(parser);
                            }
                            connectionInfo = new ConnectionInfo(hosts, connSettings);
                        }
                        if ("publications".equals(parser.currentName())) {
                            parser.nextToken();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                publications.add(parser.text());
                            }
                        }
                        if ("settings".equals(parser.currentName())) {
                            parser.nextToken();
                            settings = Settings.fromXContent(parser);
                        }
                        if (!"relations".equals(parser.currentName()) || parser.nextToken() != XContentParser.Token.START_OBJECT) continue;
                        while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                            RelationName relationName = RelationName.fromIndexName(parser.currentName());
                            Subscription.State state = null;
                            String stateReason = null;
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                if ("state".equals(parser.currentName())) {
                                    parser.nextToken();
                                    state = Subscription.State.valueOf(parser.text().toUpperCase(Locale.ENGLISH));
                                }
                                if (!"state_reason".equals(parser.currentName())) continue;
                                parser.nextToken();
                                stateReason = parser.textOrNull();
                            }
                            if (state == null) {
                                throw new ElasticsearchParseException("failed to parse subscription relation, expected field 'state' in object", new Object[0]);
                            }
                            relations.put(relationName, new Subscription.RelationState(state, stateReason));
                        }
                    }
                    if (owner == null) {
                        throw new ElasticsearchParseException("failed to parse subscription, expected field 'owner' in object", new Object[0]);
                    }
                    if (connectionInfo == null) {
                        throw new ElasticsearchParseException("failed to parse subscription, expected field 'connection_info' in object", new Object[0]);
                    }
                    if (publications.isEmpty()) {
                        throw new ElasticsearchParseException("failed to parse subscription, expected field 'publications' in object", new Object[0]);
                    }
                    if (settings == null) {
                        throw new ElasticsearchParseException("failed to parse subscription, expected field 'settings' in object", new Object[0]);
                    }
                    subscriptions.put(name, new Subscription(owner, connectionInfo, publications, settings, relations));
                }
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new ElasticsearchParseException("failed to parse subscriptions, expected an object token at the end", new Object[0]);
            }
        }
        return new SubscriptionsMetadata(subscriptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionsMetadata that = (SubscriptionsMetadata)o;
        return this.subscriptionByName.equals(that.subscriptionByName);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionByName);
    }

    public String toString() {
        return "SubscriptionsMetadata{subscriptionByName=" + String.valueOf(this.subscriptionByName) + "}";
    }
}

