/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.JwtProperties;
import io.crate.role.SecureHash;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class AlterRoleRequest
extends AcknowledgedRequest<AlterRoleRequest> {
    private final String roleName;
    private final SecureHash secureHash;
    @Nullable
    private final JwtProperties jwtProperties;
    private final boolean resetPassword;
    private final boolean resetJwtProperties;
    private final Map<Boolean, Map<String, Object>> sessionSettingsChange;

    public AlterRoleRequest(String roleName, @Nullable SecureHash secureHash, @Nullable JwtProperties jwtProperties, boolean resetPassword, boolean resetJwtProperties, Map<Boolean, Map<String, Object>> sessionSettingsChange) {
        this.roleName = roleName;
        this.secureHash = secureHash;
        this.jwtProperties = jwtProperties;
        this.resetPassword = resetPassword;
        this.resetJwtProperties = resetJwtProperties;
        this.sessionSettingsChange = sessionSettingsChange;
    }

    public String roleName() {
        return this.roleName;
    }

    @Nullable
    public SecureHash secureHash() {
        return this.secureHash;
    }

    @Nullable
    public JwtProperties jwtProperties() {
        return this.jwtProperties;
    }

    public boolean resetPassword() {
        return this.resetPassword;
    }

    public boolean resetJwtProperties() {
        return this.resetJwtProperties;
    }

    public Map<Boolean, Map<String, Object>> sessionSettingsChange() {
        return this.sessionSettingsChange;
    }

    public AlterRoleRequest(StreamInput in) throws IOException {
        super(in);
        this.roleName = in.readString();
        this.secureHash = in.readOptionalWriteable(SecureHash::readFrom);
        if (in.getVersion().onOrAfter(Version.V_5_7_0)) {
            this.jwtProperties = in.readOptionalWriteable(JwtProperties::readFrom);
            this.resetPassword = in.readBoolean();
            this.resetJwtProperties = in.readBoolean();
        } else {
            this.jwtProperties = null;
            this.resetPassword = false;
            this.resetJwtProperties = false;
        }
        this.sessionSettingsChange = in.getVersion().onOrAfter(Version.V_5_9_0) ? in.readMap(StreamInput::readBoolean, StreamInput::readMap) : Map.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.roleName);
        out.writeOptionalWriteable(this.secureHash);
        if (out.getVersion().onOrAfter(Version.V_5_7_0)) {
            out.writeOptionalWriteable(this.jwtProperties);
            out.writeBoolean(this.resetPassword);
            out.writeBoolean(this.resetJwtProperties);
        }
        if (out.getVersion().onOrAfter(Version.V_5_9_0)) {
            out.writeMap(this.sessionSettingsChange, StreamOutput::writeBoolean, StreamOutput::writeMap);
        }
    }
}

