/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PrivilegesResponse
extends AcknowledgedResponse {
    private final List<String> unknownUserNames;
    private final long affectedRows;

    PrivilegesResponse(boolean acknowledged, long affectedRows, List<String> unknownUserNames) {
        super(acknowledged);
        this.unknownUserNames = unknownUserNames;
        this.affectedRows = affectedRows;
    }

    List<String> unknownUserNames() {
        return this.unknownUserNames;
    }

    long affectedRows() {
        return this.affectedRows;
    }

    public PrivilegesResponse(StreamInput in) throws IOException {
        super(in);
        this.affectedRows = in.readLong();
        this.unknownUserNames = in.readList(StreamInput::readString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.affectedRows);
        out.writeStringCollection(this.unknownUserNames);
    }
}

