/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.auth.AccessControl;
import io.crate.auth.AccessControlImpl;
import io.crate.exceptions.RoleAlreadyExistsException;
import io.crate.exceptions.RoleUnknownException;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.role.AlterRoleRequest;
import io.crate.role.CreateRoleRequest;
import io.crate.role.DropRoleRequest;
import io.crate.role.GrantedRolesChange;
import io.crate.role.JwtProperties;
import io.crate.role.Privilege;
import io.crate.role.PrivilegesRequest;
import io.crate.role.Role;
import io.crate.role.RoleManager;
import io.crate.role.RoleManagerDDLModifier;
import io.crate.role.Roles;
import io.crate.role.SecureHash;
import io.crate.role.TransportAlterRole;
import io.crate.role.TransportCreateRole;
import io.crate.role.TransportDropRole;
import io.crate.role.TransportPrivileges;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Singleton;
import org.jetbrains.annotations.Nullable;

@Singleton
public class RoleManagerService
implements RoleManager {
    private static final RoleManagerDDLModifier DDL_MODIFIER = new RoleManagerDDLModifier();
    private final Roles roles;
    private final NodeClient client;

    private static void ensureDropRoleTargetIsNotSuperUser(Role user) {
        if (user != null && user.isSuperUser()) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot drop a superuser '%s'", user.name()));
        }
    }

    private static void ensureAlterPrivilegeTargetIsNotSuperuser(Role user) {
        if (user != null && user.isSuperUser()) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot alter privileges for superuser '%s'", user.name()));
        }
    }

    public RoleManagerService(NodeClient client, Roles roles, DDLClusterStateService ddlClusterStateService) {
        this.client = client;
        this.roles = roles;
        ddlClusterStateService.addModifier(DDL_MODIFIER);
    }

    @Override
    public CompletableFuture<Long> createRole(String roleName, boolean isUser, @Nullable SecureHash hashedPw, @Nullable JwtProperties jwtProperties) {
        CreateRoleRequest request = new CreateRoleRequest(roleName, isUser, hashedPw, jwtProperties);
        return this.client.execute(TransportCreateRole.ACTION, request).thenApply(r -> {
            if (r.doesUserExist()) {
                throw new RoleAlreadyExistsException(String.format(Locale.ENGLISH, "Role '%s' already exists", roleName));
            }
            return 1L;
        });
    }

    @Override
    public CompletableFuture<Long> dropRole(String roleName, boolean suppressNotFoundError) {
        RoleManagerService.ensureDropRoleTargetIsNotSuperUser(this.roles.findUser(roleName));
        DropRoleRequest request = new DropRoleRequest(roleName, suppressNotFoundError);
        return this.client.execute(TransportDropRole.ACTION, request).thenApply(r -> {
            if (!r.doesUserExist()) {
                if (suppressNotFoundError) {
                    return 0L;
                }
                throw new RoleUnknownException(roleName);
            }
            return 1L;
        });
    }

    @Override
    public CompletableFuture<Long> alterRole(String roleName, @Nullable SecureHash newHashedPw, @Nullable JwtProperties newJwtProperties, boolean resetPassword, boolean resetJwtProperties, Map<Boolean, Map<String, Object>> sessionSettingsChange) {
        AlterRoleRequest request = new AlterRoleRequest(roleName, newHashedPw, newJwtProperties, resetPassword, resetJwtProperties, sessionSettingsChange);
        return this.client.execute(TransportAlterRole.ACTION, request).thenApply(r -> {
            if (!r.doesUserExist()) {
                throw new RoleUnknownException(roleName);
            }
            return 1L;
        });
    }

    @Override
    public CompletableFuture<Long> applyPrivileges(Collection<String> roleNames, Collection<Privilege> privileges, GrantedRolesChange grantedRolesChange) {
        roleNames.forEach(s -> RoleManagerService.ensureAlterPrivilegeTargetIsNotSuperuser(this.roles.findUser((String)s)));
        PrivilegesRequest request = new PrivilegesRequest(roleNames, privileges, grantedRolesChange);
        return this.client.execute(TransportPrivileges.ACTION, request).thenApply(r -> {
            if (!r.unknownUserNames().isEmpty()) {
                throw new RoleUnknownException(r.unknownUserNames());
            }
            return r.affectedRows();
        });
    }

    @Override
    public AccessControl getAccessControl(Role authenticatedUser, Role sessionUser) {
        return new AccessControlImpl(this.roles, authenticatedUser, sessionUser);
    }

    @Override
    public Collection<Role> roles() {
        return this.roles.roles();
    }
}

