/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.Privilege;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.SecureHash;
import io.crate.role.metadata.RolesMetadata;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.jetbrains.annotations.Nullable;

public class RolesService
implements Roles,
ClusterStateListener {
    private volatile Map<String, Role> roles = Map.of(Role.CRATE_USER.name(), Role.CRATE_USER);

    public RolesService(ClusterService clusterService) {
        clusterService.addListener(this);
    }

    @Override
    public Collection<Role> roles() {
        return this.roles.values();
    }

    @Override
    @Nullable
    public Role findRole(String roleName) {
        return this.roles.get(roleName);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        Metadata prevMetadata = event.previousState().metadata();
        Metadata newMetadata = event.state().metadata();
        UsersMetadata prevUsers = (UsersMetadata)prevMetadata.custom("users");
        UsersMetadata newUsers = (UsersMetadata)newMetadata.custom("users");
        RolesMetadata prevRoles = (RolesMetadata)prevMetadata.custom("roles");
        RolesMetadata newRoles = (RolesMetadata)newMetadata.custom("roles");
        UsersPrivilegesMetadata prevUsersPrivileges = (UsersPrivilegesMetadata)prevMetadata.custom("users_privileges");
        UsersPrivilegesMetadata newUsersPrivileges = (UsersPrivilegesMetadata)newMetadata.custom("users_privileges");
        if (prevUsers != newUsers || prevRoles != newRoles || prevUsersPrivileges != newUsersPrivileges) {
            this.roles = RolesService.getRoles(newUsers, newRoles, newUsersPrivileges);
        }
    }

    static Map<String, Role> getRoles(@Nullable UsersMetadata usersMetadata, @Nullable RolesMetadata rolesMetadata, @Nullable UsersPrivilegesMetadata privilegesMetadata) {
        HashMap<String, Role> roles = new HashMap<String, Role>();
        roles.put(Role.CRATE_USER.name(), Role.CRATE_USER);
        if (usersMetadata != null) {
            for (Map.Entry<String, SecureHash> user : usersMetadata.users().entrySet()) {
                Set<Privilege> oldPrivileges;
                String userName = user.getKey();
                Set<Privilege> privileges = Set.of();
                if (privilegesMetadata != null && (oldPrivileges = privilegesMetadata.getUserPrivileges(userName)) != null) {
                    privileges = oldPrivileges;
                }
                roles.put(userName, new Role(userName, true, privileges, Set.of(), user.getValue(), null, Map.of()));
            }
        } else if (rolesMetadata != null) {
            roles.putAll(rolesMetadata.roles());
        }
        return Collections.unmodifiableMap(roles);
    }
}

