/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.exceptions.RoleAlreadyExistsException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.role.AlterRoleRequest;
import io.crate.role.JwtProperties;
import io.crate.role.Role;
import io.crate.role.SecureHash;
import io.crate.role.WriteRoleResponse;
import io.crate.role.metadata.RolesMetadata;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportAlterRole
extends TransportMasterNodeAction<AlterRoleRequest, WriteRoleResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportAlterRole(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, AlterRoleRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected WriteRoleResponse read(StreamInput in) throws IOException {
        return new WriteRoleResponse(in);
    }

    @Override
    protected void masterOperation(final AlterRoleRequest request, ClusterState state, ActionListener<WriteRoleResponse> listener) {
        if (!state.nodes().getMinNodeVersion().onOrAfter(Version.V_5_6_0)) {
            throw new IllegalStateException("Cannot alter users/roles until all nodes are upgraded to 5.6");
        }
        this.clusterService.submitStateUpdateTask("alter_role [" + request.roleName() + "]", new AckedClusterStateUpdateTask<WriteRoleResponse>(this, Priority.IMMEDIATE, (AckedRequest)request, listener){
            private boolean roleExists;
            {
                super(priority, request2, listener);
                this.roleExists = true;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                this.roleExists = TransportAlterRole.alterRole(mdBuilder, request.roleName(), request.secureHash(), request.jwtProperties(), request.resetPassword(), request.resetJwtProperties(), request.sessionSettingsChange());
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            protected WriteRoleResponse newResponse(boolean acknowledged) {
                return new WriteRoleResponse(acknowledged, this.roleExists);
            }
        });
    }

    @VisibleForTesting
    static boolean alterRole(Metadata.Builder mdBuilder, String roleName, @Nullable SecureHash secureHash, @Nullable JwtProperties jwtProperties, boolean resetPassword, boolean resetJwtProperties, Map<Boolean, Map<String, Object>> sessionSettingsChange) {
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        if (oldUsersMetadata == null && oldRolesMetadata == null) {
            return false;
        }
        UsersPrivilegesMetadata oldUserPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        RolesMetadata newMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldUserPrivilegesMetadata, oldRolesMetadata);
        boolean exists = false;
        Role role = newMetadata.roles().get(roleName);
        if (role != null) {
            JwtProperties newJwtProperties;
            SecureHash newSecureHash;
            if (!role.isUser()) {
                if (secureHash != null || resetPassword) {
                    throw new UnsupportedFeatureException("Setting a password to a ROLE is not allowed");
                }
                if (jwtProperties != null || resetJwtProperties) {
                    throw new UnsupportedFeatureException("Setting JWT properties to a ROLE is not allowed");
                }
                if (!sessionSettingsChange.isEmpty()) {
                    throw new UnsupportedFeatureException("Setting or resetting session settings to a ROLE is not allowed");
                }
            }
            SecureHash secureHash2 = secureHash != null ? secureHash : (newSecureHash = resetPassword ? null : role.password());
            JwtProperties jwtProperties2 = jwtProperties != null ? jwtProperties : (newJwtProperties = resetJwtProperties ? null : role.jwtProperties());
            if (jwtProperties != null && newMetadata.contains(newJwtProperties)) {
                throw new RoleAlreadyExistsException("Another role with the same combination of iss/username jwt properties already exists");
            }
            newMetadata.roles().put(roleName, role.with(newSecureHash, newJwtProperties, TransportAlterRole.getUpdatedSessionSettings(role.sessionSettings(), sessionSettingsChange)));
            exists = true;
        }
        if (newMetadata.equals(oldRolesMetadata)) {
            return exists;
        }
        assert (!newMetadata.equals(oldRolesMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("roles", newMetadata);
        return exists;
    }

    @Override
    protected ClusterBlockException checkBlock(AlterRoleRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static Map<String, Object> getUpdatedSessionSettings(Map<String, Object> oldSessionSettings, Map<Boolean, Map<String, Object>> sessionSettingsChange) {
        HashMap<String, Object> updatedSessionSettings = new HashMap<String, Object>();
        for (Map.Entry<Boolean, Map<String, Object>> change : sessionSettingsChange.entrySet()) {
            boolean isReset = change.getKey();
            Map<String, Object> settingsToChange = change.getValue();
            if (isReset) {
                if (settingsToChange.isEmpty()) {
                    return Map.of();
                }
                for (Map.Entry<String, Object> oldSetting : oldSessionSettings.entrySet()) {
                    if (settingsToChange.containsKey(oldSetting.getKey())) continue;
                    updatedSessionSettings.put(oldSetting.getKey(), oldSetting.getValue());
                }
                continue;
            }
            updatedSessionSettings.putAll(oldSessionSettings);
            updatedSessionSettings.putAll(settingsToChange);
        }
        return Collections.unmodifiableMap(updatedSessionSettings);
    }

    public static class Action
    extends ActionType<WriteRoleResponse> {
        private static String NAME = "internal:crate:sql/user/alter";

        private Action() {
            super(NAME);
        }
    }
}

