/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.GrantedRolesChange;
import io.crate.role.Policy;
import io.crate.role.PrivilegesModifier;
import io.crate.role.PrivilegesRequest;
import io.crate.role.PrivilegesResponse;
import io.crate.role.Roles;
import io.crate.role.metadata.RolesMetadata;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class TransportPrivileges
extends TransportMasterNodeAction<PrivilegesRequest, PrivilegesResponse> {
    public static final Action ACTION = new Action();
    private final Roles roles;

    @Inject
    public TransportPrivileges(TransportService transportService, ClusterService clusterService, Roles roles, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, PrivilegesRequest::new);
        this.roles = roles;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected PrivilegesResponse read(StreamInput in) throws IOException {
        return new PrivilegesResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PrivilegesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(final PrivilegesRequest request, ClusterState state, ActionListener<PrivilegesResponse> listener) throws Exception {
        if (!state.nodes().getMinNodeVersion().onOrAfter(Version.V_5_6_0)) {
            throw new IllegalStateException("Cannot grant/deny/revoke privileges until all nodes are upgraded to 5.6");
        }
        this.clusterService.submitStateUpdateTask("grant_privileges", new AckedClusterStateUpdateTask<PrivilegesResponse>(this, Priority.IMMEDIATE, (AckedRequest)request, listener){
            ApplyPrivsResult result;
            final /* synthetic */ TransportPrivileges this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
                this.result = null;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                this.result = TransportPrivileges.applyPrivileges(this.this$0.roles, mdBuilder, request);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            protected PrivilegesResponse newResponse(boolean acknowledged) {
                return new PrivilegesResponse(acknowledged, this.result.affectedRows, this.result.unknownRoleNames);
            }
        });
    }

    @VisibleForTesting
    static List<String> validateRoleNames(RolesMetadata rolesMetadata, Collection<String> roleNames) {
        if (rolesMetadata == null) {
            return new ArrayList<String>(roleNames);
        }
        ArrayList<String> unknownRoleNames = null;
        for (String roleName : roleNames) {
            if (rolesMetadata.roleNames().contains(roleName)) continue;
            if (unknownRoleNames == null) {
                unknownRoleNames = new ArrayList<String>();
            }
            unknownRoleNames.add(roleName);
        }
        if (unknownRoleNames == null) {
            return Collections.emptyList();
        }
        return unknownRoleNames;
    }

    @VisibleForTesting
    static ApplyPrivsResult applyPrivileges(Roles roles, Metadata.Builder mdBuilder, PrivilegesRequest request) {
        UsersPrivilegesMetadata oldPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        RolesMetadata newMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldPrivilegesMetadata, oldRolesMetadata);
        List<String> unknownRoleNames = TransportPrivileges.validateRoleNames(newMetadata, request.roleNames());
        long affectedRows = -1L;
        if (unknownRoleNames.isEmpty()) {
            if (!request.privileges().isEmpty()) {
                affectedRows = PrivilegesModifier.applyPrivileges(newMetadata, request.roleNames(), request.privileges());
            } else {
                unknownRoleNames = TransportPrivileges.validateRoleNames(newMetadata, request.rolePrivilege().roleNames());
                if (unknownRoleNames.isEmpty()) {
                    TransportPrivileges.validateIsNotUser(roles, request.rolePrivilege());
                    TransportPrivileges.detectCyclesInRolesHierarchy(roles, request);
                    affectedRows = newMetadata.applyRolePrivileges(request.roleNames(), request.rolePrivilege());
                }
            }
        }
        if (!newMetadata.equals(oldRolesMetadata)) {
            mdBuilder.putCustom("roles", newMetadata);
        }
        return new ApplyPrivsResult(affectedRows, unknownRoleNames);
    }

    private static void validateIsNotUser(Roles roles, GrantedRolesChange grantedRolesChange) {
        for (String roleNameToApply : grantedRolesChange.roleNames()) {
            if (!roles.findRole(roleNameToApply).isUser()) continue;
            throw new IllegalArgumentException("Cannot " + grantedRolesChange.policy().name() + " a USER to a ROLE");
        }
    }

    @VisibleForTesting
    static void detectCyclesInRolesHierarchy(Roles roles, PrivilegesRequest request) {
        if (request.rolePrivilege().policy() == Policy.GRANT) {
            for (String roleNameToGrant : request.rolePrivilege().roleNames()) {
                Set<String> parentsOfRoleToGrant = roles.findAllParents(roleNameToGrant);
                for (String grantee : request.roleNames()) {
                    if (!parentsOfRoleToGrant.contains(grantee)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot grant role %s to %s, %s is a parent role of %s and a cycle will be created", roleNameToGrant, grantee, grantee, roleNameToGrant));
                }
            }
        }
    }

    public static class Action
    extends ActionType<PrivilegesResponse> {
        private static final String NAME = "internal:crate:sql/privileges/grant";

        private Action() {
            super(NAME);
        }
    }

    record ApplyPrivsResult(long affectedRows, List<String> unknownRoleNames) {
    }
}

