/*
 * Decompiled with CFR 0.152.
 */
package io.crate.server.xcontent;

import io.crate.server.xcontent.ParsedXContent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class XContentHelper {
    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, BytesReference bytes, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = compressor.threadLocalInputStream(bytes.streamInput());
            if (!compressedInput.markSupported()) {
                compressedInput = new BufferedInputStream(compressedInput);
            }
            return xContentType.xContent().createParser(xContentRegistry, deprecationHandler, compressedInput);
        }
        return xContentType.xContent().createParser(xContentRegistry, deprecationHandler, (InputStream)bytes.streamInput());
    }

    public static Map<String, Object> toMap(BytesReference bytes, XContentType xContentType) {
        Map map;
        block8: {
            InputStream inputStream = XContentHelper.getUncompressedInputStream(bytes);
            try {
                XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, inputStream);
                map = parser.map();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return map;
    }

    public static InputStream getUncompressedInputStream(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor == null) {
            return bytes.streamInput();
        }
        InputStream compressedStreamInput = compressor.threadLocalInputStream(bytes.streamInput());
        if (compressedStreamInput.markSupported()) {
            return compressedStreamInput;
        }
        return new BufferedInputStream(compressedStreamInput);
    }

    public static ParsedXContent convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType) throws ElasticsearchParseException {
        ParsedXContent parsedXContent;
        block8: {
            InputStream input = XContentHelper.getUncompressedInputStream(bytes);
            try {
                parsedXContent = new ParsedXContent(xContentType, XContentHelper.convertToMap(xContentType.xContent(), input, ordered));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            input.close();
        }
        return parsedXContent;
    }

    public static Map<String, Object> convertToMap(XContent xContent, String string, boolean ordered) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, string);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, input);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static boolean update(Map<String, Object> source, Map<String, Object> changes, boolean checkUpdatesAreUnequal) {
        boolean modified = false;
        for (Map.Entry<String, Object> changesEntry : changes.entrySet()) {
            if (!source.containsKey(changesEntry.getKey())) {
                source.put(changesEntry.getKey(), changesEntry.getValue());
                modified = true;
                continue;
            }
            Object old = source.get(changesEntry.getKey());
            if (old instanceof Map && changesEntry.getValue() instanceof Map) {
                modified |= XContentHelper.update((Map)source.get(changesEntry.getKey()), (Map)changesEntry.getValue(), checkUpdatesAreUnequal && !modified);
                continue;
            }
            source.put(changesEntry.getKey(), changesEntry.getValue());
            if (modified) continue;
            if (!checkUpdatesAreUnequal) {
                modified = true;
                continue;
            }
            modified = !Objects.equals(old, changesEntry.getValue());
        }
        return modified;
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            List defaultList = (List)defaultEntry.getValue();
            List contentList = (List)content.get(defaultEntry.getKey());
            if (XContentHelper.allListValuesAreMapsOfOne(defaultList) && XContentHelper.allListValuesAreMapsOfOne(contentList)) {
                Map.Entry entry;
                Map map;
                LinkedHashMap<String, Map> processed = new LinkedHashMap<String, Map>();
                for (Object o : contentList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    processed.put((String)entry.getKey(), map);
                }
                for (Object o : defaultList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    if (processed.containsKey(entry.getKey())) {
                        XContentHelper.mergeDefaults((Map)processed.get(entry.getKey()), map);
                        continue;
                    }
                    processed.put((String)entry.getKey(), map);
                }
                content.put(defaultEntry.getKey(), new ArrayList(processed.values()));
                continue;
            }
            ArrayList mergedList = new ArrayList(defaultList);
            for (Object o : contentList) {
                if (mergedList.contains(o)) continue;
                mergedList.add(o);
            }
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List<Object> list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }
}

