/*
 * Decompiled with CFR 0.152.
 */
package io.crate.server.xcontent;

import io.crate.common.Booleans;
import org.elasticsearch.common.Numbers;

public class XContentMapValues {
    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            Number number = (Number)node;
            return Numbers.toIntExact(number);
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeIntegerValue(node);
    }

    public static boolean nodeBooleanValue(Object node, String name) {
        try {
            return XContentMapValues.nodeBooleanValue(node);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node) {
        return Booleans.parseBoolean((String)node.toString());
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toLongExact((Number)node);
        }
        return Long.parseLong(node.toString());
    }

    public static long nodeLongValue(Object node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeLongValue(node);
    }
}

