/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.breaker.TypedCellsAccounting;
import io.crate.common.collections.Lists;
import io.crate.data.ArrayRow;
import io.crate.data.BatchIterator;
import io.crate.data.CompositeBatchIterator;
import io.crate.data.ForwardingBatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.LimitingBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.data.breaker.RowAccounting;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.sql.tree.Declare;
import io.crate.sql.tree.Fetch;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.jetbrains.annotations.VisibleForTesting;

public final class Cursor
implements AutoCloseable {
    private final Declare.Hold hold;
    private final CompletableFuture<BatchIterator<Row>> queryIterator;
    private final CompletableFuture<Void> finalResult;
    private final List<Symbol> outputs;
    private final boolean scroll;
    private final List<Object[]> rows = new ArrayList<Object[]>();
    private final ArrayRow sharedRow = new ArrayRow();
    private final RowAccounting<Object[]> rowAccounting;
    private final long creationTime;
    private final String name;
    private final String declareStatement;
    private boolean exhausted = false;
    @VisibleForTesting
    int cursorPosition = 0;

    public Cursor(CircuitBreaker circuitBreaker, String name, String declareStatement, boolean scroll, Declare.Hold hold, CompletableFuture<BatchIterator<Row>> queryIterator, CompletableFuture<Void> finalResult, List<Symbol> outputs) {
        this.name = name;
        this.declareStatement = declareStatement;
        this.scroll = scroll;
        this.hold = hold;
        this.queryIterator = queryIterator;
        this.finalResult = finalResult;
        this.outputs = outputs;
        this.rowAccounting = new TypedCellsAccounting(Symbols.typeView(outputs), (RamAccounting)new BlockBasedRamAccounting(bytes -> circuitBreaker.addEstimateBytesAndMaybeBreak(bytes, "cursor-scroll"), 0x200000), 0);
        this.creationTime = System.currentTimeMillis();
    }

    public String name() {
        return this.name;
    }

    public String declareStatement() {
        return this.declareStatement;
    }

    public boolean isHold() {
        return this.hold == Declare.Hold.WITH;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isScrollable() {
        return this.scroll;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public Declare.Hold hold() {
        return this.hold;
    }

    public void fetch(RowConsumer consumer, Fetch.ScrollMode scrollMode, long count) {
        if (this.queryIterator.isDone()) {
            try {
                BatchIterator<Row> bi2 = this.queryIterator.join();
                this.triggerConsumer(consumer, (BatchIterator<Row>)new BufferingBatchIterator(bi2), scrollMode, count);
            }
            catch (Throwable t) {
                consumer.accept(null, t);
            }
        } else {
            this.queryIterator.whenComplete((bi, err) -> {
                if (err == null) {
                    try {
                        this.triggerConsumer(consumer, (BatchIterator<Row>)new BufferingBatchIterator((BatchIterator<Row>)bi), scrollMode, count);
                    }
                    catch (Throwable t) {
                        consumer.accept(null, t);
                    }
                } else {
                    consumer.accept(null, err);
                }
            });
        }
    }

    private BatchIterator<Row> bufferedRowOrNone(int idx) {
        if (idx < 0 || this.cursorPosition >= this.rows.size() && this.exhausted) {
            return InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL);
        }
        Object[] cells = this.rows.get(idx);
        this.sharedRow.cells(cells);
        return InMemoryBatchIterator.of((Object)this.sharedRow, (Object)SentinelRow.SENTINEL);
    }

    private void triggerConsumer(RowConsumer consumer, BatchIterator<Row> fullResult, Fetch.ScrollMode mode, long lCount) {
        boolean moveForward;
        if (lCount == Long.MAX_VALUE) {
            lCount = Integer.MAX_VALUE;
        }
        if (lCount == -9223372036854775807L) {
            lCount = -2147483647L;
        }
        int count = (int)lCount;
        boolean bl = moveForward = (mode == Fetch.ScrollMode.MOVE || mode == Fetch.ScrollMode.RELATIVE) && count >= 0 || mode == Fetch.ScrollMode.ABSOLUTE && count > this.cursorPosition;
        if (!moveForward && !this.scroll) {
            throw new IllegalArgumentException("Cannot move backward if cursor was created with NO SCROLL");
        }
        this.resetCursorToMaxBufferedRowsPlus1();
        if (mode == Fetch.ScrollMode.ABSOLUTE) {
            if (count < this.rows.size()) {
                this.cursorPosition = Math.max(count, 0);
                consumer.accept(this.bufferedRowOrNone(count - 1), null);
            } else {
                int steps = count - this.cursorPosition + 1;
                fullResult.move(steps, row -> {}, err -> {
                    if (err == null) {
                        if (count > this.rows.size()) {
                            consumer.accept(null, (Throwable)new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot return row: %s, total rows: %s", count, this.rows.size())));
                        } else {
                            consumer.accept(this.bufferedRowOrNone(count - 1), null);
                            this.cursorPosition = count;
                        }
                    } else {
                        consumer.accept(null, err);
                    }
                });
            }
        } else if (mode == Fetch.ScrollMode.RELATIVE) {
            int newCursorPosition = this.newCursorPosition(count);
            if (newCursorPosition < this.rows.size()) {
                this.cursorPosition = Math.max(newCursorPosition, 0);
                consumer.accept(this.bufferedRowOrNone(this.cursorPosition - 1), null);
            } else {
                int steps = newCursorPosition - this.cursorPosition + 1;
                fullResult.move(steps, row -> {}, err -> {
                    if (err == null) {
                        this.cursorPosition = newCursorPosition;
                        consumer.accept(this.bufferedRowOrNone(this.cursorPosition - 1), null);
                    } else {
                        consumer.accept(null, err);
                    }
                });
            }
        } else if (moveForward) {
            BatchIterator delegate;
            if (count == 0) {
                int idx = this.cursorPosition - 1;
                if (this.cursorPosition > this.rows.size()) {
                    --idx;
                }
                consumer.accept(this.bufferedRowOrNone(idx), null);
                return;
            }
            if (!this.scroll || this.cursorPosition >= this.rows.size()) {
                delegate = fullResult;
            } else {
                List<Object[]> items = this.rows.subList(this.cursorPosition, this.rows.size());
                BatchIterator<Row> bufferedBi = this.biFromItems(items);
                delegate = CompositeBatchIterator.seqComposite((BatchIterator[])new BatchIterator[]{bufferedBi, fullResult});
            }
            this.cursorPosition = this.newCursorPosition(count);
            consumer.accept(LimitingBatchIterator.newInstance(delegate, (int)count), null);
        } else {
            int start = this.cursorPosition + count;
            assert (start < this.cursorPosition) : "count must be negative";
            List items = Lists.reverse(this.rows.subList(Math.max(start - 1, 0), Math.max(this.cursorPosition - 1, 0)));
            BatchIterator<Row> bi = this.biFromItems(items);
            this.cursorPosition = Math.max(start, 0);
            consumer.accept(bi, null);
        }
    }

    private void resetCursorToMaxBufferedRowsPlus1() {
        if (this.cursorPosition > this.rows.size() + 1) {
            this.cursorPosition = this.rows.size() + 1;
        }
    }

    private int newCursorPosition(int count) {
        int newCursorPosition = this.cursorPosition + count;
        if (((this.cursorPosition ^ newCursorPosition) & (count ^ newCursorPosition)) < 0) {
            return Integer.MAX_VALUE;
        }
        return newCursorPosition;
    }

    private BatchIterator<Row> biFromItems(List<Object[]> items) {
        BatchIterator objectRows = items.isEmpty() ? InMemoryBatchIterator.empty(null) : InMemoryBatchIterator.of(items, null, (boolean)false);
        return objectRows.map(cells -> {
            this.sharedRow.cells(cells);
            return this.sharedRow;
        });
    }

    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void close() {
        this.rowAccounting.release();
        if (this.queryIterator.isDone() && !this.queryIterator.isCompletedExceptionally()) {
            this.queryIterator.join().close();
            this.finalResult.complete(null);
        } else {
            this.queryIterator.whenComplete((bi, err) -> {
                if (bi != null) {
                    bi.close();
                }
                if (err == null) {
                    this.finalResult.complete(null);
                } else {
                    this.finalResult.completeExceptionally((Throwable)err);
                }
            });
        }
    }

    private class BufferingBatchIterator
    extends ForwardingBatchIterator<Row> {
        private final BatchIterator<Row> delegate;

        BufferingBatchIterator(BatchIterator<Row> delegate) {
            this.delegate = delegate;
        }

        protected BatchIterator<Row> delegate() {
            return this.delegate;
        }

        public boolean moveNext() {
            boolean moveNext = this.delegate.moveNext();
            if (moveNext) {
                if (Cursor.this.scroll) {
                    Object[] row = ((Row)this.currentElement()).materialize();
                    Cursor.this.rowAccounting.accountForAndMaybeBreak((Object)row);
                    Cursor.this.rows.add(row);
                }
                return true;
            }
            Cursor.this.exhausted = true;
            return false;
        }

        public void close() {
        }
    }
}

