/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.data.Row;
import io.crate.exceptions.SQLExceptions;
import io.crate.session.ResultReceiver;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.ConnectTransportException;
import org.jetbrains.annotations.Nullable;

public class RetryOnFailureResultReceiver<T>
implements ResultReceiver<T> {
    private static final Logger LOGGER = LogManager.getLogger(RetryOnFailureResultReceiver.class);
    private final ClusterService clusterService;
    private final ResultReceiver<T> delegate;
    private final UUID jobId;
    private final BiConsumer<UUID, ResultReceiver<T>> retryAction;
    private final int maxRetryCount;
    private int attempt = 1;

    public RetryOnFailureResultReceiver(int maxRetryCount, ClusterService clusterService, ResultReceiver<T> delegate, UUID jobId, BiConsumer<UUID, ResultReceiver<T>> retryAction) {
        this.maxRetryCount = maxRetryCount;
        this.clusterService = clusterService;
        this.delegate = delegate;
        this.jobId = jobId;
        this.retryAction = retryAction;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) throws Exception {
        return this.delegate.setNextRow(row);
    }

    @Override
    public void batchFinished() {
        this.delegate.batchFinished();
    }

    @Override
    public void allFinished() {
        this.delegate.allFinished();
    }

    @Override
    public void fail(Throwable wrappedError) {
        Throwable error = SQLExceptions.unwrap(wrappedError);
        if (this.attempt <= this.maxRetryCount && (SQLExceptions.isShardNotAvailable(error) || error instanceof ConnectTransportException)) {
            if (this.clusterService.state().blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
                this.delegate.fail(error);
            } else {
                ++this.attempt;
                UUID newJobId = UUIDs.dirtyUUID();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Retrying statement due to a shard failure, attempt={}, jobId={}->{}", (Object)this.attempt, (Object)this.jobId, (Object)newJobId);
                }
                this.retryAction.accept(newJobId, this);
            }
        } else {
            this.delegate.fail(error);
        }
    }

    @Override
    public CompletableFuture<T> completionFuture() {
        return this.delegate.completionFuture();
    }

    public String toString() {
        return "RetryOnFailureResultReceiver{delegate=" + String.valueOf(this.delegate) + ", jobId=" + String.valueOf(this.jobId) + ", attempt=" + this.attempt + "}";
    }
}

