/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.SQLExceptions;
import io.crate.session.ResultReceiver;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RowConsumerToResultReceiver
implements RowConsumer {
    private static final Logger LOGGER = LogManager.getLogger(RowConsumerToResultReceiver.class);
    private final CompletableFuture<?> completionFuture = new CompletableFuture();
    private ResultReceiver<?> resultReceiver;
    private int maxRows;
    private int rowCount = 0;
    private BatchIterator<Row> activeIt;

    public RowConsumerToResultReceiver(ResultReceiver<?> resultReceiver, int maxRows, Consumer<Throwable> onCompletion) {
        this.resultReceiver = resultReceiver;
        this.maxRows = maxRows;
        this.completionFuture.whenComplete((res, err) -> onCompletion.accept((Throwable)err));
    }

    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.consumeIt(iterator);
        } else {
            if (iterator != null) {
                iterator.close();
            }
            this.completionFuture.completeExceptionally(failure);
            this.resultReceiver.fail(failure);
        }
    }

    public CompletableFuture<?> completionFuture() {
        return this.completionFuture;
    }

    private void consumeIt(BatchIterator<Row> iterator) {
        try {
            CompletableFuture nextBatch;
            while (true) {
                if (iterator.moveNext()) {
                    ++this.rowCount;
                    CompletableFuture<Void> writeFuture = this.resultReceiver.setNextRow((Row)iterator.currentElement());
                    if (writeFuture != null) {
                        LOGGER.trace("Suspended execution after {} rows as the receiver is not writable anymore", (Object)this.rowCount);
                        this.activeIt = iterator;
                        writeFuture.thenRun(() -> {
                            LOGGER.trace("Resume execution after {} rows", (Object)this.rowCount);
                            this.resume();
                        });
                        return;
                    }
                    if (this.maxRows <= 0 || this.rowCount % this.maxRows != 0) continue;
                    this.activeIt = iterator;
                    this.resultReceiver.batchFinished();
                    return;
                }
                if (iterator.allLoaded()) {
                    this.completionFuture.complete(null);
                    iterator.close();
                    this.resultReceiver.allFinished();
                    return;
                }
                nextBatch = iterator.loadNextBatch().toCompletableFuture();
                if (!nextBatch.isDone()) break;
                if (!nextBatch.isCompletedExceptionally()) continue;
                nextBatch.join();
            }
            nextBatch.whenComplete((r, f) -> {
                if (f == null) {
                    this.consumeIt(iterator);
                } else {
                    Throwable t = SQLExceptions.unwrap(f);
                    iterator.close();
                    this.completionFuture.completeExceptionally(t);
                    this.resultReceiver.fail(t);
                }
            });
            return;
        }
        catch (Throwable t) {
            iterator.close();
            this.completionFuture.completeExceptionally(t);
            this.resultReceiver.fail(t);
            return;
        }
    }

    public void closeAndFinishIfSuspended() {
        if (this.activeIt != null) {
            this.activeIt.close();
            this.completionFuture.complete(null);
        }
    }

    public boolean suspended() {
        return this.activeIt != null;
    }

    public void replaceResultReceiver(ResultReceiver<?> resultReceiver, int maxRows) {
        if (!this.resultReceiver.completionFuture().isDone()) {
            this.resultReceiver.allFinished();
        }
        this.rowCount = 0;
        this.resultReceiver = resultReceiver;
        this.maxRows = maxRows;
    }

    public void resume() {
        assert (this.activeIt != null) : "resume must only be called if suspended() returned true and activeIt is not null";
        BatchIterator<Row> iterator = this.activeIt;
        this.activeIt = null;
        this.consumeIt(iterator);
    }

    public String toString() {
        return "RowConsumerToResultReceiver{resultReceiver=" + String.valueOf(this.resultReceiver) + ", maxRows=" + this.maxRows + ", rowCount=" + this.rowCount + ", activeIt=" + String.valueOf(this.activeIt) + "}";
    }
}

