/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session.parser;

import io.crate.exceptions.SQLParseException;
import io.crate.session.parser.SQLArgsParseElement;
import io.crate.session.parser.SQLBulkArgsParseElement;
import io.crate.session.parser.SQLParseElement;
import io.crate.session.parser.SQLParseSourceException;
import io.crate.session.parser.SQLRequestParseContext;
import io.crate.session.parser.SQLStmtParseElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class SQLRequestParser {
    private static final Map<String, SQLParseElement> ELEMENT_PARSERS = Map.of("stmt", new SQLStmtParseElement(), "args", new SQLArgsParseElement(), "bulk_args", new SQLBulkArgsParseElement());

    private SQLRequestParser() {
    }

    public static SQLRequestParseContext parseSource(BytesReference source) throws IOException {
        if (source.length() == 0) {
            throw new SQLParseException("Missing request body");
        }
        try (XContentParser parser = null;){
            SQLRequestParseContext parseContext = new SQLRequestParseContext();
            parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)source.streamInput());
            SQLRequestParser.parse(parseContext, parser);
            if (parseContext.stmt() == null) {
                throw new SQLParseSourceException("Field [stmt] was not defined");
            }
            SQLRequestParseContext sQLRequestParseContext = parseContext;
            return sQLRequestParseContext;
        }
    }

    private static void parse(SQLRequestParseContext parseContext, XContentParser parser) throws Exception {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String fieldName = parser.currentName();
                parser.nextToken();
                SQLParseElement element = ELEMENT_PARSERS.get(fieldName);
                if (element == null) {
                    throw new SQLParseException("No parser for element [" + fieldName + "]");
                }
                element.parse(parser, parseContext);
                continue;
            }
            if (token != null) continue;
            break;
        }
    }

    static final class Fields {
        static final String STMT = "stmt";
        static final String ARGS = "args";
        static final String BULK_ARGS = "bulk_args";

        Fields() {
        }
    }
}

