/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.DistinctValuesSketch;
import io.crate.statistics.HistogramSketch;
import io.crate.statistics.MostCommonValues;
import io.crate.statistics.MostCommonValuesSketch;
import io.crate.types.DataType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class ColumnSketchBuilder<T> {
    protected final DataType<T> dataType;
    protected long sampleCount;
    protected long nullCount;
    protected long totalBytes;
    protected DistinctValuesSketch distinctSketch;
    public static final Streamer<BytesRef> BYTE_ARRAY_STREAMER = new Streamer<BytesRef>(){

        @Override
        public BytesRef readValueFrom(StreamInput in) throws IOException {
            byte[] b = in.readByteArray();
            return new BytesRef(b);
        }

        @Override
        public void writeValueTo(StreamOutput out, BytesRef v) throws IOException {
            out.writeVInt(v.length);
            out.writeBytes(v.bytes, v.offset, v.length);
        }
    };

    public ColumnSketchBuilder(DataType<T> dataType) {
        this.dataType = dataType;
        this.distinctSketch = DistinctValuesSketch.newSketch();
    }

    public ColumnSketchBuilder(DataType<T> dataType, StreamInput in) throws IOException {
        this.dataType = dataType;
        this.sampleCount = in.readLong();
        this.nullCount = in.readLong();
        this.totalBytes = in.readLong();
        this.distinctSketch = DistinctValuesSketch.fromStream(in);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.sampleCount);
        out.writeLong(this.nullCount);
        out.writeLong(this.totalBytes);
        out.writeByteArray(this.distinctSketch.getSketch().toByteArray());
        this.writeSketches(out);
    }

    protected abstract void writeSketches(StreamOutput var1) throws IOException;

    public void add(T value) {
        ++this.sampleCount;
        if (value == null) {
            ++this.nullCount;
        } else {
            this.totalBytes += this.dataType.valueBytes(value);
            this.distinctSketch.update(value.toString());
            this.updateSketches(value);
        }
    }

    protected abstract void updateSketches(T var1);

    public final void addAll(Collection<T> values) {
        for (T v : values) {
            this.add(v);
        }
    }

    public abstract ColumnSketchBuilder<T> merge(ColumnSketchBuilder<?> var1);

    public abstract ColumnStats<T> toStats();

    double nullFraction() {
        if (this.nullCount == 0L || this.sampleCount == 0L) {
            return 0.0;
        }
        return (double)this.nullCount / (double)this.sampleCount;
    }

    public static class Composite<T>
    extends ColumnSketchBuilder<T> {
        private MostCommonValuesSketch<BytesRef> mostCommonValuesSketch;
        private final BytesStreamOutput scratch = new BytesStreamOutput();

        public Composite(DataType<T> dataType) {
            super(dataType);
            this.mostCommonValuesSketch = new MostCommonValuesSketch(BYTE_ARRAY_STREAMER);
        }

        public Composite(DataType<T> dataType, StreamInput in) throws IOException {
            super(dataType, in);
            this.mostCommonValuesSketch = new MostCommonValuesSketch(BYTE_ARRAY_STREAMER, in);
        }

        @Override
        protected void writeSketches(StreamOutput out) throws IOException {
            this.mostCommonValuesSketch.writeTo(out);
        }

        @Override
        protected void updateSketches(T value) {
            try {
                this.scratch.reset();
                this.dataType.streamer().writeValueTo(this.scratch, value);
                BytesRef bv = this.scratch.copyBytes().toBytesRef();
                this.mostCommonValuesSketch.update(bv);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public ColumnSketchBuilder<T> merge(ColumnSketchBuilder<?> other) {
            if (!Objects.equals(this.dataType, other.dataType)) {
                throw new IllegalArgumentException("Columns must be of the same data type");
            }
            Composite typedOther = (Composite)other;
            this.sampleCount += other.sampleCount;
            this.nullCount += other.nullCount;
            this.totalBytes += other.totalBytes;
            this.distinctSketch = this.distinctSketch.merge(other.distinctSketch);
            this.mostCommonValuesSketch = this.mostCommonValuesSketch.merge(typedOther.mostCommonValuesSketch);
            return this;
        }

        @Override
        public ColumnStats<T> toStats() {
            double nullFraction = this.nullFraction();
            double avgSizeInBytes = (double)this.totalBytes / ((double)this.sampleCount - (double)this.nullCount);
            double approxDistinct = this.distinctSketch.getSketch().getEstimate();
            MostCommonValues<Object> mcv = this.mostCommonValuesSketch.toMostCommonValues(this.sampleCount, approxDistinct, this::fromByteStream);
            return new ColumnStats<Object>(nullFraction, avgSizeInBytes, approxDistinct, this.dataType, mcv, List.of());
        }

        private T fromByteStream(BytesRef bytes) {
            try {
                return this.dataType.streamer().readValueFrom(StreamInput.wrap(bytes.bytes, bytes.offset, bytes.length));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class SingleValued<T>
    extends ColumnSketchBuilder<T> {
        private MostCommonValuesSketch<T> mostCommonValuesSketch;
        private HistogramSketch<T> histogramSketch;

        public SingleValued(Class<T> clazz, DataType<T> dataType) {
            super(dataType);
            this.mostCommonValuesSketch = new MostCommonValuesSketch<T>(dataType.streamer());
            this.histogramSketch = new HistogramSketch<T>(clazz, dataType);
        }

        public SingleValued(Class<T> clazz, DataType<T> dataType, StreamInput in) throws IOException {
            super(dataType, in);
            this.mostCommonValuesSketch = new MostCommonValuesSketch<T>(dataType.streamer(), in);
            this.histogramSketch = new HistogramSketch<T>(clazz, dataType, in);
        }

        @Override
        protected void writeSketches(StreamOutput out) throws IOException {
            this.mostCommonValuesSketch.writeTo(out);
            this.histogramSketch.writeTo(out);
        }

        @Override
        protected void updateSketches(T value) {
            this.mostCommonValuesSketch.update(value);
            this.histogramSketch.update(value);
        }

        @Override
        public ColumnSketchBuilder<T> merge(ColumnSketchBuilder<?> other) {
            if (!Objects.equals(this.dataType, other.dataType)) {
                throw new IllegalArgumentException("Columns must be of the same data type");
            }
            SingleValued typedOther = (SingleValued)other;
            this.sampleCount += other.sampleCount;
            this.nullCount += other.nullCount;
            this.totalBytes += other.totalBytes;
            this.distinctSketch = this.distinctSketch.merge(other.distinctSketch);
            this.mostCommonValuesSketch = this.mostCommonValuesSketch.merge(typedOther.mostCommonValuesSketch);
            this.histogramSketch = this.histogramSketch.merge(typedOther.histogramSketch);
            return this;
        }

        @Override
        public ColumnStats<T> toStats() {
            double nullFraction = this.nullFraction();
            double avgSizeInBytes = (double)this.totalBytes / ((double)this.sampleCount - (double)this.nullCount);
            double approxDistinct = this.distinctSketch.getSketch().getEstimate();
            MostCommonValues<T> mcv = this.mostCommonValuesSketch.toMostCommonValues(this.sampleCount, approxDistinct);
            return new ColumnStats<T>(nullFraction, avgSizeInBytes, approxDistinct, this.dataType, mcv, this.histogramSketch.toHistogram(100, mcv.values()));
        }
    }
}

