/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.statistics.ColumnSketchBuilder;
import io.crate.types.DataType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;

public interface ColumnStatsSupport<T> {
    public ColumnSketchBuilder<T> sketchBuilder();

    public ColumnSketchBuilder<T> readSketchFrom(StreamInput var1) throws IOException;

    public static <T> ColumnStatsSupport<T> singleValued(final Class<T> clazz, final DataType<T> dataType) {
        return new ColumnStatsSupport<T>(){

            @Override
            public ColumnSketchBuilder<T> sketchBuilder() {
                return new ColumnSketchBuilder.SingleValued(clazz, dataType);
            }

            @Override
            public ColumnSketchBuilder<T> readSketchFrom(StreamInput in) throws IOException {
                return new ColumnSketchBuilder.SingleValued(clazz, dataType, in);
            }
        };
    }

    public static <T> ColumnStatsSupport<T> composite(final DataType<T> dataType) {
        return new ColumnStatsSupport<T>(){

            @Override
            public ColumnSketchBuilder<T> sketchBuilder() {
                return new ColumnSketchBuilder.Composite(dataType);
            }

            @Override
            public ColumnSketchBuilder<T> readSketchFrom(StreamInput in) throws IOException {
                return new ColumnSketchBuilder.Composite(dataType, in);
            }
        };
    }
}

