/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.statistics.ColumnSketchBuilder;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.Stats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

class Samples
implements Writeable {
    static final Samples EMPTY = new Samples(List.of(), 0L, 0L);
    private final List<ColumnSketchBuilder<?>> columnSketches;
    private final long numTotalDocs;
    private final long numTotalSizeInBytes;

    Samples(List<ColumnSketchBuilder<?>> columnSketches, long numTotalDocs, long numTotalSizeInBytes) {
        this.columnSketches = columnSketches;
        this.numTotalDocs = numTotalDocs;
        this.numTotalSizeInBytes = numTotalSizeInBytes;
    }

    public Samples(List<Reference> references, StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_5_7_0)) {
            throw new UnsupportedOperationException("Cannot run ANALYZE in a mixed version cluster");
        }
        this.numTotalDocs = in.readLong();
        this.numTotalSizeInBytes = in.readLong();
        int numRecords = in.readVInt();
        if (numRecords != references.size()) {
            throw new IllegalStateException("Expected to receive stats for " + numRecords + " columns but received " + numRecords);
        }
        this.columnSketches = new ArrayList(numRecords);
        for (int i = 0; i < numRecords; ++i) {
            Reference ref = references.get(i);
            this.columnSketches.add(ref.valueType().columnStatsSupport().readSketchFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (out.getVersion().onOrAfter(Version.V_5_7_0)) : "ANALYZE in mixed-version cluster should have been caught by FetchSampleRequest constructor";
        out.writeLong(this.numTotalDocs);
        out.writeLong(this.numTotalSizeInBytes);
        out.writeVInt(this.columnSketches.size());
        for (ColumnSketchBuilder<?> stats : this.columnSketches) {
            stats.writeTo(out);
        }
    }

    public static Samples merge(Samples s1, Samples s2) {
        if (s1 == EMPTY) {
            return s2;
        }
        if (s2 == EMPTY) {
            return s1;
        }
        if (s1.columnSketches.size() != s2.columnSketches.size()) {
            throw new IllegalArgumentException("Column mismatch");
        }
        ArrayList mergedColumns = new ArrayList();
        for (int i = 0; i < s1.columnSketches.size(); ++i) {
            ColumnSketchBuilder<?> merged = s1.columnSketches.get(i).merge(s2.columnSketches.get(i));
            mergedColumns.add(merged);
        }
        return new Samples(mergedColumns, s1.numTotalDocs + s2.numTotalDocs, s1.numTotalSizeInBytes + s2.numTotalSizeInBytes);
    }

    public Stats createTableStats(List<Reference> primitiveColumns) {
        HashMap<ColumnIdent, ColumnStats<?>> statsByColumn = HashMap.newHashMap(primitiveColumns.size());
        for (int i = 0; i < primitiveColumns.size(); ++i) {
            Reference primitiveColumn = primitiveColumns.get(i);
            statsByColumn.put(primitiveColumn.column(), this.columnSketches.get(i).toStats());
        }
        return new Stats(this.numTotalDocs, this.numTotalSizeInBytes, statsByColumn);
    }
}

