/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.data.breaker.RamAccounting;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.store.RateLimiter;

public class SketchRamAccounting
implements AutoCloseable {
    private static final int BLOCK_SIZE = 1024;
    private static final int SHIFTED_BLOCK_SIZE = 32;
    private final RamAccounting ramAccounting;
    private final RateLimiter rateLimiter;
    private long blockCache;
    private long bytesSinceLastPause;

    public SketchRamAccounting(RamAccounting ramAccounting, RateLimiter rateLimiter) {
        this.ramAccounting = ramAccounting;
        this.rateLimiter = rateLimiter;
    }

    public void addBytes(long bytes) {
        this.blockCache += bytes;
        boolean checklimit = false;
        while (this.blockCache > 1024L) {
            this.blockCache -= 1024L;
            this.ramAccounting.addBytes(32L);
            checklimit = true;
        }
        if (checklimit) {
            this.checkRateLimit(bytes);
        }
    }

    private void checkRateLimit(long bytes) {
        if (this.rateLimiter.getMBPerSec() > 0.0) {
            this.bytesSinceLastPause += bytes;
            if (this.bytesSinceLastPause >= this.rateLimiter.getMinPauseCheckBytes()) {
                try {
                    this.rateLimiter.pause(this.bytesSinceLastPause);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    this.bytesSinceLastPause = 0L;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ramAccounting.close();
    }
}

