/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.common.concurrent.CompletableFutures;
import io.crate.concurrent.FutureActionListener;
import io.crate.concurrent.MultiActionListener;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocSchemaInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.statistics.FetchSampleRequest;
import io.crate.statistics.FetchSampleResponse;
import io.crate.statistics.PublishTableStatsRequest;
import io.crate.statistics.ReservoirSampler;
import io.crate.statistics.Samples;
import io.crate.statistics.Stats;
import io.crate.statistics.TableStats;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public final class TransportAnalyzeAction {
    private static final String FETCH_SAMPLES = "internal:crate:sql/analyze/fetch_samples";
    private static final String RECEIVE_TABLE_STATS = "internal:crate:sql/analyze/receive_stats";
    private final TransportService transportService;
    private final Schemas schemas;
    private final ClusterService clusterService;
    private final ConcurrentHashMap<FetchSampleRequest, CompletableFuture<Samples>> analysisByRequest = new ConcurrentHashMap();
    private final Executor executor;

    @Inject
    public TransportAnalyzeAction(TransportService transportService, ReservoirSampler reservoirSampler, NodeContext nodeContext, ClusterService clusterService, TableStats tableStats, ThreadPool threadPool) {
        this.transportService = transportService;
        this.schemas = nodeContext.schemas();
        this.clusterService = clusterService;
        this.executor = threadPool.executor("search");
        transportService.registerRequestHandler(FETCH_SAMPLES, "same", FetchSampleRequest::new, new NodeActionRequestHandler(req -> {
            CompletableFuture<Samples> newSamples = new CompletableFuture<Samples>();
            CompletableFuture previous = this.analysisByRequest.putIfAbsent((FetchSampleRequest)req, newSamples);
            if (previous == null) {
                newSamples.completeAsync(() -> reservoirSampler.getSamples(req.relation(), req.columns()), this.executor);
                return ((CompletableFuture)newSamples.thenApply(FetchSampleResponse::new)).whenComplete((res, err) -> this.analysisByRequest.remove(req));
            }
            return previous.thenApply(FetchSampleResponse::new);
        }));
        transportService.registerRequestHandler(RECEIVE_TABLE_STATS, "same", PublishTableStatsRequest::new, new NodeActionRequestHandler(req -> {
            tableStats.updateTableStats(req.tableStats());
            return CompletableFuture.completedFuture(new AcknowledgedResponse(true));
        }));
    }

    public CompletableFuture<AcknowledgedResponse> fetchSamplesThenGenerateAndPublishStats() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (SchemaInfo schema : this.schemas) {
            if (!(schema instanceof DocSchemaInfo)) continue;
            for (TableInfo table : schema.getTables()) {
                List<Reference> primitiveColumns = StreamSupport.stream(table.spliterator(), false).filter(x -> !x.column().isSystemColumn()).filter(x -> DataTypes.isPrimitive(x.valueType())).map(x -> table.getReadReference(x.column())).toList();
                futures.add(this.fetchSamples(table.ident(), primitiveColumns).thenApply(samples -> Map.entry(table.ident(), samples.createTableStats(primitiveColumns))));
            }
        }
        return CompletableFutures.allAsList(futures).thenCompose(entries -> this.publishTableStats(Map.ofEntries(entries.toArray(new Map.Entry[0]))));
    }

    private CompletableFuture<AcknowledgedResponse> publishTableStats(Map<RelationName, Stats> newTableStats) {
        DiscoveryNodes discoveryNodes = this.clusterService.state().nodes();
        FutureActionListener<AcknowledgedResponse> listener = new FutureActionListener<AcknowledgedResponse>();
        MultiActionListener multiListener = new MultiActionListener(discoveryNodes.getSize(), Collectors.reducing(new AcknowledgedResponse(true), (resp1, resp2) -> new AcknowledgedResponse(resp1.isAcknowledged() && resp2.isAcknowledged())), listener);
        ActionListenerResponseHandler<AcknowledgedResponse> responseHandler = new ActionListenerResponseHandler<AcknowledgedResponse>(RECEIVE_TABLE_STATS, multiListener, AcknowledgedResponse::new, "same");
        PublishTableStatsRequest request = new PublishTableStatsRequest(newTableStats);
        for (DiscoveryNode node : discoveryNodes) {
            this.transportService.sendRequest(node, RECEIVE_TABLE_STATS, request, responseHandler);
        }
        return listener;
    }

    private CompletableFuture<Samples> fetchSamples(RelationName relationName, List<Reference> columns) {
        FutureActionListener listener = new FutureActionListener();
        DiscoveryNodes discoveryNodes = this.clusterService.state().nodes();
        MultiActionListener multiListener = new MultiActionListener(discoveryNodes.getSize(), Collectors.reducing(new FetchSampleResponse(Samples.EMPTY), FetchSampleResponse::merge), listener);
        ActionListenerResponseHandler<FetchSampleResponse> responseHandler = new ActionListenerResponseHandler<FetchSampleResponse>(FETCH_SAMPLES, multiListener, in -> new FetchSampleResponse(columns, in), "same");
        for (DiscoveryNode node : discoveryNodes) {
            this.transportService.sendRequest(node, FETCH_SAMPLES, new FetchSampleRequest(relationName, columns, node.getVersion()), responseHandler);
        }
        return listener.thenApply(FetchSampleResponse::samples);
    }
}

