/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import ch.randelshofer.fastdoubleparser.JavaDoubleParser;
import io.crate.Streamer;
import io.crate.execution.dml.DoubleIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.EqQuery;
import io.crate.types.FixedWidthType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DoubleType
extends DataType<Double>
implements FixedWidthType,
Streamer<Double> {
    public static final DoubleType INSTANCE = new DoubleType();
    public static final int ID = 6;
    public static final int PRECISION = 53;
    public static final int DOUBLE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Double.class);
    private static final StorageSupport<Double> STORAGE = new StorageSupport<Double>(true, true, (EqQuery)new EqQuery<Double>(){

        @Override
        public Query termQuery(String field, Double value, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return DoublePoint.newExactQuery((String)field, (double)value);
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)value));
            }
            return null;
        }

        @Override
        public Query rangeQuery(String field, Double lowerTerm, Double upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, boolean isIndexed) {
            double upper;
            double lower;
            if (lowerTerm == null) {
                lower = Double.NEGATIVE_INFINITY;
            } else {
                double d = lower = includeLower ? lowerTerm : DoublePoint.nextUp((double)lowerTerm);
            }
            if (upperTerm == null) {
                upper = Double.POSITIVE_INFINITY;
            } else {
                double d = upper = includeUpper ? upperTerm : DoublePoint.nextDown((double)upperTerm);
            }
            if (isIndexed) {
                return DoublePoint.newRangeQuery((String)field, (double)lower, (double)upper);
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)lower), (long)NumericUtils.doubleToSortableLong((double)upper));
            }
            return null;
        }

        @Override
        public Query termsQuery(String field, List<Double> nonNullValues, boolean hasDocValues, boolean isIndexed) {
            if (isIndexed) {
                return DoublePoint.newSetQuery((String)field, nonNullValues);
            }
            if (hasDocValues) {
                return SortedNumericDocValuesField.newSlowSetQuery((String)field, (long[])nonNullValues.stream().mapToLong(NumericUtils::doubleToSortableLong).toArray());
            }
            return null;
        }
    }){

        @Override
        public ValueIndexer<Number> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new DoubleIndexer(ref);
        }
    };
    private static final BigDecimal DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN = BigDecimal.valueOf(-1.7976931348623157E308);

    private DoubleType() {
    }

    @Override
    public int id() {
        return 6;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.DOUBLE;
    }

    @Override
    public String getName() {
        return "double precision";
    }

    @Override
    public Integer numericPrecision() {
        return 53;
    }

    @Override
    public Streamer<Double> streamer() {
        return this;
    }

    @Override
    public Double implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return d;
        }
        if (value instanceof String) {
            String s = (String)value;
            return JavaDoubleParser.parseDouble((CharSequence)s);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            if (DOUBLE_MAX.compareTo(bigDecimalValue) <= 0 || DOUBLE_MIN.compareTo(bigDecimalValue) >= 0) {
                throw new IllegalArgumentException(this.getName() + " value out of range: " + String.valueOf(value));
            }
            return bigDecimalValue.doubleValue();
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.doubleValue();
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Double sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return d;
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public int compare(Double val1, Double val2) {
        return Double.compare(val1, val2);
    }

    @Override
    public Double readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Double.valueOf(in.readDouble());
    }

    @Override
    public void writeValueTo(StreamOutput out, Double v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeDouble(v);
        }
    }

    @Override
    public int fixedSize() {
        return DOUBLE_SIZE;
    }

    @Override
    public StorageSupport<Double> storageSupport() {
        return STORAGE;
    }

    @Override
    public ColumnStatsSupport<Double> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(Double.class, this);
    }

    @Override
    public long valueBytes(Double value) {
        return DOUBLE_SIZE;
    }
}

